/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.kecs;

import de.dfki.sds.hephaistos.DataStoreDescription;
import de.dfki.sds.hephaistos.storage.InternalStorageMetaData;
import de.dfki.sds.hephaistos.storage.StorageManager;
import de.dfki.sds.hephaistos.storage.assertion.AssertionPool;
import de.dfki.sds.hephaistos.storage.assertion.Phase;
import de.dfki.sds.hephaistos.storage.excel.ExcelStorageIO;
import de.dfki.sds.hephaistos.storage.file.FileInfoStorage;
import de.dfki.sds.hephaistos.storage.file.FileInfoStorageIO;
import de.dfki.sds.kecs.KecsSettings;
import de.dfki.sds.kecs.ml.DefaultItemEmbedding;
import de.dfki.sds.kecs.ml.StatusManager;
import de.dfki.sds.kecs.ml.VisualManager;
import de.dfki.sds.kecs.modules.DomainTerminologyExtraction;
import de.dfki.sds.kecs.modules.Module;
import de.dfki.sds.kecs.util.ColumnMemoryExcelStorage;
import de.dfki.sds.kecs.util.ExceptionUtility;
import de.dfki.sds.mschroeder.commons.lang.swing.EmptyLoadingListener;
import de.dfki.sds.mschroeder.commons.lang.swing.LoadingListener;
import de.dfki.sds.stringanalyzer.helper.GermaNet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class KecsManager {
    private Map<Phase, Module> phase2module;
    private StorageManager storageManager;
    private FileInfoStorage fileInfoStorage;
    private AssertionPool assertionPool;
    private StatusManager statusManager;
    private VisualManager visualManager;
    private KecsSettings settings;

    public KecsManager(KecsSettings settings) {
        this.settings = settings;
        this.phase2module = new HashMap<Phase, Module>();
    }

    public void loadEmbedding() {
        long begin = System.currentTimeMillis();
        DefaultItemEmbedding embedding = new DefaultItemEmbedding("/de/dfki/sds/kecs/auxiliary/country_state_city_month_years_names_stopword_germanet_dict_lemma.csv.gz", false);
        long end = System.currentTimeMillis();
        System.out.println("DefaultItemEmbedding init took " + (end - begin) + " ms");
        this.phase2module.values().forEach(m -> m.setEmbedding(embedding));
    }

    public void loadLanguageResource() {
        GermaNet germaNet;
        long begin = System.currentTimeMillis();
        try {
            String filename = this.settings.getLanguage() == KecsSettings.Language.de ? "germanet.json.gz" : "wordnet.json.gz";
            germaNet = new GermaNet(new GZIPInputStream(KecsManager.class.getResourceAsStream("/de/dfki/sds/kecs/auxiliary/" + filename)));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        long end = System.currentTimeMillis();
        this.phase2module.values().forEach(m -> m.setGermaNet(germaNet));
        System.out.println("Language Resource for " + (Object)((Object)this.settings.getLanguage()) + " init took " + (end - begin) + " ms " + germaNet.getStatusLine());
    }

    public void bootstrapFromFilesystemDump(File filesystemDumpFile, File assertionPoolFolder, String charset, boolean filePathList, String fileSeparator) {
        if (assertionPoolFolder.exists()) {
            throw new RuntimeException("There is already a folder at " + assertionPoolFolder + ". Use load or replay method");
        }
        this.openStorage(assertionPoolFolder);
        this.printLoading("Load dump into file info storage", () -> {
            FileInfoStorageIO io = new FileInfoStorageIO();
            DataStoreDescription dsd = new DataStoreDescription();
            dsd.getLocators().add(filesystemDumpFile.getAbsolutePath());
            dsd.getPreference().setValue("charset", charset);
            dsd.getPreference().setValue("file path list", filePathList);
            dsd.getPreference().setValue("separator", fileSeparator);
            dsd.getPreference().setValue("gzip", filesystemDumpFile.getName().endsWith("gz"));
            try {
                io.importing(dsd, this.fileInfoStorage, (LoadingListener)new EmptyLoadingListener());
            }
            catch (IOException ex) {
                ExceptionUtility.save(ex);
                throw new RuntimeException(ex);
            }
        });
        this.modulesBootstrap();
    }

    public void bootstrapFromFilesystem(File rootFolder, File assertionPoolFolder, int limit) {
        if (assertionPoolFolder.exists()) {
            throw new RuntimeException("There is already a folder at " + assertionPoolFolder + ". Use load or replay method");
        }
        if (rootFolder.isFile()) {
            throw new RuntimeException("The input file has to be a folder");
        }
        this.openStorage(assertionPoolFolder);
        this.printLoading("Load native filesystem into file info storage", () -> {
            FileInfoStorageIO io = new FileInfoStorageIO();
            DataStoreDescription dsd = new DataStoreDescription();
            dsd.getLocators().add(rootFolder.getAbsolutePath());
            dsd.getPreference().setValue("max limit", limit);
            try {
                io.importing(dsd, this.fileInfoStorage, (LoadingListener)new EmptyLoadingListener());
            }
            catch (IOException ex) {
                ExceptionUtility.save(ex);
                throw new RuntimeException(ex);
            }
        });
        this.modulesBootstrap();
    }

    public void bootstrapFromExcel(File excelFile, File assertionPoolFolder) {
        if (assertionPoolFolder.exists()) {
            throw new RuntimeException("There is already a folder at " + assertionPoolFolder + ". Use load or replay method");
        }
        this.openStorage(assertionPoolFolder);
        this.printLoading("Load excel into file info storage", () -> {
            ExcelStorageIO io = new ExcelStorageIO();
            DataStoreDescription dsd = new DataStoreDescription();
            dsd.getLocators().add(excelFile.getAbsolutePath());
            ColumnMemoryExcelStorage excelStorage = new ColumnMemoryExcelStorage(new InternalStorageMetaData("id", "ColumnMemoryExcelStorage"));
            try {
                io.importing(dsd, excelStorage, (LoadingListener)new EmptyLoadingListener());
            }
            catch (IOException ex) {
                ExceptionUtility.save(ex);
                throw new RuntimeException(ex);
            }
            ColumnMemoryExcelStorage.convertToTree(excelStorage, this.fileInfoStorage, this.settings);
        });
        this.modulesBootstrap();
    }

    private void openStorage(File assertionPoolFolder) {
        this.printLoading("Open storage", () -> {
            this.storageManager = new StorageManager(assertionPoolFolder);
            this.storageManager.open();
            this.fileInfoStorage = this.storageManager.getFileInfoStorage("classificationSchema");
            this.assertionPool = this.storageManager.getAssertionPool("Assertion");
            this.assertionPool.getCounter().reset("concept");
            this.assertionPool.getCounter().reset("type");
        });
    }

    private void modulesBootstrap() {
        this.assertionPool.setBulkMode(true);
        for (Module module : this.getModules()) {
            this.printLoading("Init and bootstrap module " + module.getClass().getSimpleName(), () -> {
                module.init(this.fileInfoStorage, this.assertionPool, this.settings);
                module.bootstrap(this.fileInfoStorage, this.assertionPool, this.settings);
            });
        }
        this.assertionPool.setBulkMode(false);
        for (Module module : this.getModules()) {
            this.assertionPool.addListener(module);
        }
        this.printLoading("Init status manager", () -> {
            this.statusManager = new StatusManager(this.fileInfoStorage, this.assertionPool, this.settings);
        });
        this.printLoading("Init visual manager", () -> {
            this.visualManager = new VisualManager(this.fileInfoStorage, this.assertionPool, this.settings);
        });
    }

    public void closeStorage() {
        this.printLoading("Close storage", () -> this.storageManager.close());
    }

    public void loadAssertionPool(File assertionPoolFolder) {
        this.printLoading("Open storage", () -> {
            this.storageManager = new StorageManager(assertionPoolFolder);
            this.storageManager.open();
            this.fileInfoStorage = this.storageManager.getFileInfoStorage("classificationSchema");
            this.assertionPool = this.storageManager.getAssertionPool("Assertion");
        });
        this.assertionPool.clearNotificationBuffer();
        for (Module module : this.getModules()) {
            this.printLoading("Init module " + module.getClass().getSimpleName(), () -> module.init(this.fileInfoStorage, this.assertionPool, this.settings));
            this.assertionPool.addListener(module);
        }
        this.printLoading("Init status manager", () -> {
            this.statusManager = new StatusManager(this.fileInfoStorage, this.assertionPool, this.settings);
        });
        this.printLoading("Init visual manager", () -> {
            this.visualManager = new VisualManager(this.fileInfoStorage, this.assertionPool, this.settings);
        });
    }

    public void loadDemo(File assertionPoolFolder) {
        FileUtils.deleteQuietly(assertionPoolFolder);
        try {
            byte[] data = IOUtils.toByteArray(KecsManager.class.getResourceAsStream("/de/dfki/sds/kecs/auxiliary/demo_" + this.settings.getLanguage().name() + ".txt"));
            File dumpFile = new File("kecs-demo.txt");
            FileUtils.writeByteArrayToFile(dumpFile, data);
            this.bootstrapFromFilesystemDump(dumpFile, assertionPoolFolder, "UTF-8", false, "/");
            FileUtils.deleteQuietly(dumpFile);
            this.closeStorage();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.loadAssertionPool(assertionPoolFolder);
    }

    public List<Module> getModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (Phase phase : Phase.values()) {
            Module module = this.phase2module.get((Object)phase);
            if (module == null) continue;
            modules.add(module);
        }
        return modules;
    }

    public void setModule(Phase phase, Module module) {
        this.phase2module.put(phase, module);
    }

    public AssertionPool getAssertionPool() {
        return this.assertionPool;
    }

    private void printLoading(String message, Runnable run) {
        System.out.println(message);
        long begin = System.currentTimeMillis();
        run.run();
        long end = System.currentTimeMillis();
        System.out.println("took " + (end - begin) + " ms");
    }

    public FileInfoStorage getFileInfoStorage() {
        return this.fileInfoStorage;
    }

    public StatusManager getStatusManager() {
        return this.statusManager;
    }

    public VisualManager getVisualManager() {
        return this.visualManager;
    }

    public KecsSettings getSettings() {
        return this.settings;
    }

    public DomainTerminologyExtraction getDomainTerminologyExtraction() {
        return (DomainTerminologyExtraction)this.phase2module.get((Object)Phase.DomainTerminologyExtraction);
    }
}

