/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.kecs;

import de.dfki.sds.hephaistos.storage.assertion.Phase;
import de.dfki.sds.kecs.KecsManager;
import de.dfki.sds.kecs.KecsSettings;
import de.dfki.sds.kecs.modules.ConceptDiscovery;
import de.dfki.sds.kecs.modules.ConceptHierarchyDerivation;
import de.dfki.sds.kecs.modules.DomainTerminologyExtraction;
import de.dfki.sds.kecs.modules.NonTaxonomicRelationLearning;
import de.dfki.sds.kecs.modules.OntologyPopulation;
import de.dfki.sds.kecs.server.KecsHumlServer;
import de.dfki.sds.kecs.util.ExceptionUtility;
import de.dfki.sds.mschroeder.commons.lang.MemoryUtility;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;

public class KecsApp {
    public static final String VERSION = "2022-03-14";
    public static Model creator = ModelFactory.createDefaultModel();
    private KecsSettings settings;

    public KecsApp(String[] args) {
        this.settings = KecsSettings.loadCommandline(args);
    }

    public void run() {
        KecsManager manager = new KecsManager(this.settings);
        manager.setModule(Phase.DomainTerminologyExtraction, new DomainTerminologyExtraction());
        manager.setModule(Phase.ConceptDiscovery, new ConceptDiscovery());
        manager.setModule(Phase.OntologyPopulation, new OntologyPopulation());
        manager.setModule(Phase.ConceptHierarchyDerivation, new ConceptHierarchyDerivation());
        manager.setModule(Phase.NonTaxonomicRelationLearning, new NonTaxonomicRelationLearning());
        if (this.settings.isRunServer()) {
            if (this.settings.isLoadEmbedding()) {
                manager.loadEmbedding();
            }
            if (this.settings.isLoadLanguageResource()) {
                manager.loadLanguageResource();
            }
        }
        switch (this.settings.getMode()) {
            case BootstrapFilesystem: {
                manager.bootstrapFromFilesystem(this.settings.getInput(), this.settings.getOutputFolder(), this.settings.getLimit());
                break;
            }
            case BootstrapFilesystemDump: {
                manager.bootstrapFromFilesystemDump(this.settings.getInput(), this.settings.getOutputFolder(), this.settings.getCharset(), this.settings.isFilePathList(), this.settings.getFileSeparator());
                break;
            }
            case BootstrapExcel: {
                manager.bootstrapFromExcel(this.settings.getInput(), this.settings.getOutputFolder());
                break;
            }
            case Load: {
                manager.loadAssertionPool(this.settings.getOutputFolder());
                break;
            }
            case Demo: {
                manager.loadDemo(this.settings.getOutputFolder());
            }
        }
        if (this.settings.isRunServer()) {
            KecsHumlServer server = new KecsHumlServer(this.settings.getPort(), this.settings.getUserCsvFile(), manager, this.settings.getOutputFolder(), this.settings.getLanguage());
            server.start();
            if (this.settings.isOpenBrowser()) {
                try {
                    Desktop.getDesktop().browse(new URI("http://localhost:" + this.settings.getPort()));
                }
                catch (IOException | URISyntaxException ex) {
                    ExceptionUtility.save(ex);
                    throw new RuntimeException(ex);
                }
            }
        } else {
            manager.closeStorage();
        }
        System.out.println(MemoryUtility.memoryStatistics());
    }

    public static void main(String[] args) {
        KecsApp app = new KecsApp(args);
        app.run();
    }
}

