/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.hephaistos.storage.file;

import de.dfki.sds.hephaistos.DataStoreDescription;
import de.dfki.sds.hephaistos.Preference;
import de.dfki.sds.hephaistos.Setting;
import de.dfki.sds.hephaistos.storage.DataIO;
import de.dfki.sds.hephaistos.storage.DataModel;
import de.dfki.sds.hephaistos.storage.InternalStorage;
import de.dfki.sds.hephaistos.storage.StorageManager;
import de.dfki.sds.hephaistos.storage.file.FileInfo;
import de.dfki.sds.hephaistos.storage.file.FileInfoStorage;
import de.dfki.sds.hephaistos.storage.file.FolderInfo;
import de.dfki.sds.mschroeder.commons.lang.FileUtility;
import de.dfki.sds.mschroeder.commons.lang.RegexUtility;
import de.dfki.sds.mschroeder.commons.lang.swing.LoadingListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringJoiner;
import java.util.zip.GZIPInputStream;
import javax.swing.tree.TreeModel;
import org.apache.commons.io.FilenameUtils;
import org.json.JSONObject;

public class FileInfoStorageIO
extends DataIO<FileInfoStorage, TreeModel> {
    @Override
    public InternalStorage createInternalStorage(StorageManager storageManager) {
        return storageManager.getFileInfoStorage();
    }

    @Override
    public void exporting(FileInfoStorage from, DataStoreDescription to, LoadingListener listener) {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public void importing(DataStoreDescription from, FileInfoStorage to, LoadingListener listener) throws IOException {
        int fileInfoId = 2;
        for (String locator : from.getLocators()) {
            File locatedFile = new File(locator);
            if (locatedFile.isFile()) {
                boolean filePathList = from.getPreference().getValueAsBoolean("file path list", false);
                if (filePathList) {
                    this.importingFromFilePathList(locatedFile, from, to, listener);
                    continue;
                }
                this.importingFromLinuxFind(locatedFile, from, to, listener);
                continue;
            }
            if (!locatedFile.isDirectory()) continue;
            fileInfoId = this.importingFromLocalFilesystem(locatedFile, from, to, listener, fileInfoId);
        }
    }

    private void importingFromFilePathList(File file, DataStoreDescription desc, FileInfoStorage to, LoadingListener listener) throws IOException {
        Node cur;
        String line;
        String charsetName = desc.getPreference().getValueAsString("charset", "UTF-8");
        String separator = desc.getPreference().getValueAsString("separator", "/");
        InputStream is = new FileInputStream(file);
        if (desc.getPreference().getValueAsBoolean("gzip")) {
            is = new GZIPInputStream(is);
        }
        InputStreamReader isr = new InputStreamReader(is, charsetName);
        BufferedReader br = new BufferedReader(isr);
        int id = 2;
        HashSet<FileInfo> bulk = new HashSet<FileInfo>();
        int lineCount = FileUtility.countLines(file);
        listener.setMaximum(lineCount);
        listener.setCurrent(1);
        int lineIndex = 1;
        class Node {
            String name;
            Map<String, Node> name2child = new HashMap<String, Node>();
            boolean isFile;
            Node parent;
            FileInfo fileInfo;
            String uri;
            String line;

            Node() {
            }
        }
        Node root2 = new Node();
        root2.name = "ROOT";
        while ((line = br.readLine()) != null) {
            listener.setCurrent(lineIndex++);
            if (listener.cancel()) break;
            ArrayList<String> segments = new ArrayList<String>(Arrays.asList(line.split(RegexUtility.quote(separator))));
            cur = root2;
            for (int i = 0; i < segments.size(); ++i) {
                String seg = (String)segments.get(i);
                if (cur.name2child.containsKey(seg)) {
                    cur = cur.name2child.get(seg);
                    continue;
                }
                Node n = new Node();
                n.name = seg;
                n.isFile = i == segments.size() - 1;
                cur.name2child.put(seg, n);
                n.parent = cur;
                StringJoiner sj = new StringJoiner(separator);
                segments.subList(0, i + 1).forEach(str2 -> sj.add((CharSequence)str2));
                n.line = sj.toString();
                cur = n;
            }
        }
        if (listener.cancel()) {
            return;
        }
        LinkedList<Node> queue = new LinkedList<Node>();
        queue.add(root2);
        while (!queue.isEmpty() && !listener.cancel()) {
            cur = (Node)queue.poll();
            ArrayList<Node> childNodes = new ArrayList<Node>(cur.name2child.values());
            childNodes.sort((a, b) -> {
                int cmp = Boolean.compare(b.isFile, a.isFile);
                if (cmp == 0) {
                    return a.name.compareToIgnoreCase(b.name);
                }
                return cmp;
            });
            int sortIndex = 0;
            for (Node childNode : childNodes) {
                FileInfo fi = !childNode.isFile ? new FolderInfo() : new FileInfo();
                fi.setId(id);
                fi.setDirectory(!childNode.isFile);
                fi.setPath(childNode.line);
                fi.setName(childNode.name);
                fi.setSort(sortIndex++);
                String basename = childNode.name;
                if (childNode.isFile) {
                    basename = FilenameUtils.getBaseName(childNode.name);
                }
                JSONObject meta = new JSONObject();
                meta.put("uri", "urn:file:" + id);
                meta.put("basename", basename);
                fi.setMeta(meta.toString());
                childNode.fileInfo = fi;
                if (childNode.parent != root2) {
                    fi.setParent(childNode.parent.fileInfo.getId());
                } else {
                    fi.setParent(1);
                }
                ++id;
                bulk.add(fi);
                queue.add(childNode);
            }
        }
        to.insertBulk(bulk);
    }

    private void importingFromLinuxFind(File file, DataStoreDescription desc, FileInfoStorage to, LoadingListener listener) throws IOException {
        String line;
        int maxDepth = desc.getPreference().getValueAsInt("max depth", -1);
        int maxLimit = desc.getPreference().getValueAsInt("max limit", -1);
        boolean allowHidden = desc.getPreference().getValueAsBoolean("hidden", false);
        boolean tika = desc.getPreference().getValueAsBoolean("tika", false);
        String charsetName = desc.getPreference().getValueAsString("charset", "UTF-8");
        String separator = desc.getPreference().getValueAsString("separator", "/");
        InputStream is = new FileInputStream(file);
        if (desc.getPreference().getValueAsBoolean("gzip")) {
            is = new GZIPInputStream(is);
        }
        InputStreamReader isr = new InputStreamReader(is, charsetName);
        BufferedReader br = new BufferedReader(isr);
        HashMap<String, FileInfo> id2f = new HashMap<String, FileInfo>();
        HashMap<FileInfo, Integer> file2depth = new HashMap<FileInfo, Integer>();
        FileInfo root2 = null;
        ArrayList<String> errorLines = new ArrayList<String>();
        ArrayList<String> missingParent = new ArrayList<String>();
        int id = 2;
        HashSet<FileInfo> bulk = new HashSet<FileInfo>();
        int lineCount = FileUtility.countLines(file);
        listener.setMaximum(lineCount);
        listener.setCurrent(1);
        int lineIndex = 1;
        while ((line = br.readLine()) != null) {
            String path;
            String type;
            listener.setCurrent(lineIndex++);
            if (line.contains("\t")) {
                String[] split = line.split("\\t");
                type = split[0].trim();
                path = split[1];
            } else {
                type = line.substring(0, 1);
                path = line.substring(2, line.length());
            }
            int lastSep = path.lastIndexOf(separator);
            if (lastSep == -1) {
                errorLines.add(line);
                continue;
            }
            String parentPath = path.substring(0, lastSep);
            String childName = path.substring(lastSep + 1, path.length());
            FileInfo parent = (FileInfo)id2f.get(parentPath);
            FileInfo child = type.equals("d") || type.equals("DIR") ? new FolderInfo() : new FileInfo();
            child.setId(id);
            child.setDirectory(type.equals("d") || type.equals("DIR"));
            child.setPath(path);
            child.setName(childName);
            String basename = childName;
            if (!child.isDirectory()) {
                basename = FilenameUtils.getBaseName(childName);
            }
            JSONObject meta = new JSONObject();
            meta.put("uri", "urn:file:" + id);
            meta.put("basename", basename);
            child.setMeta(meta.toString());
            ++id;
            bulk.add(child);
            if (parent != null) {
                child.setParent(parent.getId());
            }
            int parentDepth = 0;
            if (parent != null) {
                parentDepth = (Integer)file2depth.get(parent);
            } else if (root2 != null) {
                missingParent.add(line);
                continue;
            }
            if (root2 == null) {
                root2 = child;
                file2depth.put(root2, 1);
                root2.setParent(1);
            }
            int childDepth = parentDepth + 1;
            file2depth.put(child, childDepth);
            if (maxDepth > -1 && childDepth > maxDepth) continue;
            id2f.put(path, child);
            if (maxLimit <= -1 || bulk.size() < maxLimit) continue;
            break;
        }
        to.insertBulk(bulk);
    }

    private int importingFromLocalFilesystem(File root2, DataStoreDescription desc, FileInfoStorage to, LoadingListener listener, int startId) {
        int maxDepth = desc.getPreference().getValueAsInt("max depth", -1);
        int maxLimit = desc.getPreference().getValueAsInt("max limit", -1);
        boolean allowHidden = desc.getPreference().getValueAsBoolean("hidden", false);
        boolean tika = desc.getPreference().getValueAsBoolean("tika", false);
        FileFilter filefilter = null;
        LinkedList<FileUtility.FileDepth> q = new LinkedList<FileUtility.FileDepth>();
        q.add(new FileUtility.FileDepth(root2, null, 0));
        HashMap<File, FileInfo> file2fi = new HashMap<File, FileInfo>();
        int fileInfoId = startId;
        int currentProgress = 0;
        int maxProgress = 0;
        while (!q.isEmpty() && !listener.cancel()) {
            listener.setMaximum(maxProgress);
            listener.setCurrent(currentProgress);
            FileUtility.FileDepth fd = (FileUtility.FileDepth)q.poll();
            FileInfo fiCur = this.fromFile(fd.file, fileInfoId++, tika, root2);
            file2fi.put(fd.file, fiCur);
            if (fd.parent != null) {
                if (fiCur.getId() == startId) {
                    fiCur.setParent(1);
                } else {
                    fiCur.setParent(((FileInfo)file2fi.get(fd.parent)).getId());
                }
            } else {
                fiCur.setParent(1);
            }
            file2fi.put(fd.file, fiCur);
            if (maxDepth != -1 && fd.depth >= maxDepth || maxLimit != -1 && file2fi.size() >= maxLimit) break;
            File[] children = filefilter != null ? fd.file.listFiles(filefilter) : fd.file.listFiles();
            if (children != null) {
                maxProgress += children.length;
                ArrayList<File> childList = new ArrayList<File>(Arrays.asList(children));
                childList.sort((a, b) -> a.getName().compareToIgnoreCase(b.getName()));
                for (File child : childList) {
                    if (!allowHidden && (child.isHidden() || child.getName().startsWith("."))) continue;
                    q.add(new FileUtility.FileDepth(child, fd.file, fd.depth + 1));
                }
            }
            ++currentProgress;
        }
        to.insertBulk(file2fi.values());
        return fileInfoId;
    }

    private FileInfo fromFile(File file, int id, boolean tika, File root2) {
        FileInfo fi = file.isDirectory() ? new FolderInfo() : new FileInfo();
        fi.setId(id);
        fi.setName(file.getName());
        fi.setDirectory(file.isDirectory());
        fi.setPath(file.getAbsolutePath().replace(root2.getAbsolutePath(), ""));
        fi.setSize(file.length());
        String basename = file.getName();
        if (!fi.isDirectory()) {
            basename = FilenameUtils.getBaseName(file.getName());
        }
        JSONObject meta = new JSONObject();
        meta.put("uri", "urn:file:" + id);
        meta.put("basename", file == root2 ? "" : basename);
        fi.setMeta(meta.toString());
        if (tika) {
            // empty if block
        }
        return fi;
    }

    @Override
    public TreeModel preview(DataStoreDescription from) {
        return null;
    }

    @Override
    public Preference getPreference() {
        return new Preference(new Setting("gzip", false), new Setting("charset", "UTF-8"), new Setting("max depth", -1), new Setting("max limit", -1), new Setting("hidden", false), new Setting("tika", false));
    }

    @Override
    public String getName() {
        return "Hierarchical File System";
    }

    @Override
    public DataModel getDataModel() {
        return DataModel.Hierarchical;
    }
}

