/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.hephaistos.storage.excel;

import de.dfki.sds.hephaistos.DataStoreDescription;
import de.dfki.sds.hephaistos.Preference;
import de.dfki.sds.hephaistos.storage.DataIO;
import de.dfki.sds.hephaistos.storage.DataModel;
import de.dfki.sds.hephaistos.storage.InternalStorage;
import de.dfki.sds.hephaistos.storage.StorageManager;
import de.dfki.sds.hephaistos.storage.excel.ExcelCell;
import de.dfki.sds.hephaistos.storage.excel.ExcelSheet;
import de.dfki.sds.hephaistos.storage.excel.ExcelStorage;
import de.dfki.sds.hephaistos.storage.excel.ExcelTextStyle;
import de.dfki.sds.mschroeder.commons.lang.MemoryUtility;
import de.dfki.sds.mschroeder.commons.lang.swing.LoadingListener;
import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.table.TableModel;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FontUnderline;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelStorageIO
extends DataIO<ExcelStorage, TableModel> {
    private Dimension getMaxima(Sheet sheet) {
        int w = 0;
        int h = 0;
        int minRow = sheet.getFirstRowNum();
        int maxRow = sheet.getLastRowNum() + 1;
        h = Math.max(h, maxRow);
        for (int k = minRow; k < maxRow; ++k) {
            Row row = sheet.getRow(k);
            if (row == null) continue;
            short maxCol = row.getLastCellNum();
            w = Math.max(w, maxCol);
        }
        return new Dimension(w, h);
    }

    private Color toAwtColor(XSSFColor color) {
        if (color == null || color.getARGB() == null) {
            return null;
        }
        return new Color(color.getARGB()[1] & 0xFF, color.getARGB()[2] & 0xFF, color.getARGB()[3] & 0xFF, color.getARGB()[0] & 0xFF);
    }

    @Override
    public InternalStorage createInternalStorage(StorageManager storageManager) {
        return null;
    }

    @Override
    public void exporting(ExcelStorage from, DataStoreDescription to, LoadingListener listener) {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public void importing(DataStoreDescription from, ExcelStorage to, LoadingListener listener) throws IOException {
        ZipSecureFile.setMinInflateRatio(0.0);
        int CELL_BUFFER_SIZE = 10000;
        int TEXT_STYLE_BUFFER_SIZE = 10000;
        boolean ignoreBlank = true;
        int sheetId = 1;
        int cellId = 1;
        int textStyleId = 1;
        ArrayList<ExcelSheet> sheetBuffer = new ArrayList<ExcelSheet>();
        ArrayList<ExcelCell> cellBuffer = new ArrayList<ExcelCell>();
        ArrayList<ExcelTextStyle> textStyleBuffer = new ArrayList<ExcelTextStyle>();
        for (String locator : from.getLocators()) {
            Workbook workbook;
            File locatorFile = new File(locator);
            String fileSize = MemoryUtility.humanReadableByteCount(locatorFile.length());
            listener.status("Load workbook " + locatorFile.getName() + " with " + fileSize);
            FileInputStream fis = new FileInputStream(locator);
            if (locator.endsWith("xls")) {
                try {
                    workbook = new HSSFWorkbook(fis);
                }
                catch (OfficeXmlFileException e2) {
                    fis = new FileInputStream(locator);
                    workbook = new XSSFWorkbook(fis);
                }
            } else {
                workbook = new XSSFWorkbook(fis);
            }
            if (listener.cancel()) break;
            System.gc();
            for (int i = 0; i < workbook.getNumberOfSheets() && !listener.cancel(); ++i) {
                if (from.getParts() != null && !from.getParts().isEmpty() && !from.getParts().contains(workbook.getSheetAt(i).getSheetName())) {
                    listener.status("Skip Sheet " + workbook.getSheetAt(i).getSheetName());
                    continue;
                }
                ExcelSheet excelSheet = new ExcelSheet();
                sheetBuffer.add(excelSheet);
                excelSheet.setId(sheetId++);
                excelSheet.setFilename(locatorFile.getName());
                excelSheet.setFilePath(locatorFile.getPath());
                Sheet sheet = workbook.getSheetAt(i);
                Dimension maxima = this.getMaxima(sheet);
                int numberOfCells = maxima.width * maxima.height;
                excelSheet.setName(sheet.getSheetName());
                excelSheet.setWidth(maxima.width);
                excelSheet.setHeight(maxima.height);
                int runningCellNumber = 1;
                listener.status("Load Sheet " + sheet.getSheetName() + " with approx. " + numberOfCells + " cells");
                listener.setMaximum(numberOfCells);
                listener.setCurrent(runningCellNumber++);
                int minRow = sheet.getFirstRowNum();
                int maxRow = sheet.getLastRowNum();
                block18: for (int k = minRow; k <= maxRow; ++k) {
                    Row row = sheet.getRow(k);
                    if (row == null) continue;
                    if (listener.cancel()) break;
                    int minCol = row.getFirstCellNum();
                    short maxCol = row.getLastCellNum();
                    if (minCol < 0) {
                        minCol = 0;
                    }
                    for (int j = minCol; j <= maxCol; ++j) {
                        Font font;
                        CellStyle cs;
                        Cell cell = row.getCell(j);
                        if (cell == null) continue;
                        if (listener.cancel()) continue block18;
                        if (cell.getCellType() == CellType.BLANK) continue;
                        ExcelCell excelCell = new ExcelCell();
                        cellBuffer.add(excelCell);
                        excelCell.setId(cellId++);
                        excelCell.setSheetId(excelSheet.getId());
                        CellStyle cst = cell.getCellStyle();
                        if (cst instanceof XSSFCellStyle) {
                            cs = (XSSFCellStyle)cell.getCellStyle();
                            font = ((XSSFCellStyle)cs).getFont();
                            excelCell.setFontBold(((XSSFFont)font).getBold());
                            excelCell.setFontItalic(((XSSFFont)font).getItalic());
                            excelCell.setFontStrikeout(((XSSFFont)font).getStrikeout());
                            excelCell.setFontUnderline(((XSSFFont)font).getUnderline() != FontUnderline.NONE.getByteValue());
                            excelCell.setFontName(((XSSFFont)font).getFontName());
                            excelCell.setFontColor(this.toAwtColor(((XSSFFont)font).getXSSFColor()));
                            excelCell.setFontSize(((XSSFFont)font).getFontHeightInPoints());
                            excelCell.setForegroundColor(this.toAwtColor(((XSSFCellStyle)cs).getFillForegroundColorColor()));
                            excelCell.setBackgroundColor(this.toAwtColor(((XSSFCellStyle)cs).getFillBackgroundColorColor()));
                            excelCell.setRotation(((XSSFCellStyle)cs).getRotation());
                            excelCell.setHorizontalAlignment(((XSSFCellStyle)cs).getAlignmentEnum().toString().toLowerCase());
                            excelCell.setVerticalAlignment(((XSSFCellStyle)cs).getVerticalAlignmentEnum().toString().toLowerCase());
                            excelCell.setBorderTop(((XSSFCellStyle)cs).getBorderTopEnum().toString().toLowerCase());
                            excelCell.setBorderLeft(((XSSFCellStyle)cs).getBorderLeftEnum().toString().toLowerCase());
                            excelCell.setBorderRight(((XSSFCellStyle)cs).getBorderRightEnum().toString().toLowerCase());
                            excelCell.setBorderBottom(((XSSFCellStyle)cs).getBorderBottomEnum().toString().toLowerCase());
                            excelCell.setDataFormat(((XSSFCellStyle)cs).getDataFormatString());
                        } else if (cst instanceof HSSFCellStyle) {
                            cs = (HSSFCellStyle)cell.getCellStyle();
                            font = ((HSSFCellStyle)cs).getFont(workbook);
                            excelCell.setFontBold(((HSSFFont)font).getBold());
                            excelCell.setFontItalic(((HSSFFont)font).getItalic());
                            excelCell.setFontStrikeout(((HSSFFont)font).getStrikeout());
                            excelCell.setFontUnderline(((HSSFFont)font).getUnderline() != FontUnderline.NONE.getByteValue());
                            excelCell.setFontName(((HSSFFont)font).getFontName());
                            excelCell.setFontSize(((HSSFFont)font).getFontHeightInPoints());
                            excelCell.setRotation(((HSSFCellStyle)cs).getRotation());
                            excelCell.setHorizontalAlignment(((HSSFCellStyle)cs).getAlignmentEnum().toString().toLowerCase());
                            excelCell.setVerticalAlignment(((HSSFCellStyle)cs).getVerticalAlignmentEnum().toString().toLowerCase());
                            excelCell.setBorderTop(((HSSFCellStyle)cs).getBorderTopEnum().toString().toLowerCase());
                            excelCell.setBorderLeft(((HSSFCellStyle)cs).getBorderLeftEnum().toString().toLowerCase());
                            excelCell.setBorderRight(((HSSFCellStyle)cs).getBorderRightEnum().toString().toLowerCase());
                            excelCell.setBorderBottom(((HSSFCellStyle)cs).getBorderBottomEnum().toString().toLowerCase());
                            excelCell.setDataFormat(((HSSFCellStyle)cs).getDataFormatString());
                        }
                        CellType formularCellType = null;
                        excelCell.setCellType(cell.getCellTypeEnum().toString().toLowerCase());
                        switch (cell.getCellTypeEnum()) {
                            case NUMERIC: {
                                excelCell.setValueNumeric(cell.getNumericCellValue());
                                break;
                            }
                            case BOOLEAN: {
                                excelCell.setValueBoolean(cell.getBooleanCellValue());
                                break;
                            }
                            case STRING: {
                                XSSFRichTextString rts;
                                String plainText = cell.getStringCellValue();
                                excelCell.setValueString(plainText);
                                StringBuilder richTextBuilder = new StringBuilder();
                                RichTextString richTextString = cell.getRichStringCellValue();
                                if (richTextString instanceof XSSFRichTextString && (rts = (XSSFRichTextString)richTextString).hasFormatting()) {
                                    for (int r = 0; r < rts.numFormattingRuns(); ++r) {
                                        ExcelTextStyle textStyle = new ExcelTextStyle();
                                        int begin = rts.getIndexOfFormattingRun(r);
                                        int length = rts.getLengthOfFormattingRun(r);
                                        String subtext = plainText.substring(begin, begin + length);
                                        textStyle.setId(textStyleId++);
                                        textStyle.setCellId(excelCell.getId());
                                        textStyle.setBegin(begin);
                                        textStyle.setEnd(begin + length);
                                        textStyle.setText(subtext);
                                        XSSFFont font2 = rts.getFontOfFormattingRun(r);
                                        if (font2 == null && cst instanceof XSSFCellStyle) {
                                            XSSFFont cellFont;
                                            XSSFCellStyle cs2 = (XSSFCellStyle)cell.getCellStyle();
                                            font2 = cellFont = cs2.getFont();
                                        }
                                        if (font2 != null) {
                                            textStyle.setFontBold(font2.getBold());
                                            if (font2.getBold()) {
                                                richTextBuilder.append("<b>");
                                            }
                                            textStyle.setFontItalic(font2.getItalic());
                                            if (font2.getItalic()) {
                                                richTextBuilder.append("<i>");
                                            }
                                            textStyle.setFontStrikeout(font2.getStrikeout());
                                            if (font2.getStrikeout()) {
                                                richTextBuilder.append("<strike>");
                                            }
                                            boolean underline = font2.getUnderline() != FontUnderline.NONE.getByteValue();
                                            textStyle.setFontUnderline(underline);
                                            if (underline) {
                                                richTextBuilder.append("<u>");
                                            }
                                            textStyle.setFontName(font2.getFontName());
                                            textStyle.setFontSize(font2.getFontHeightInPoints());
                                            textStyle.setFontColor(this.toAwtColor(font2.getXSSFColor()));
                                            richTextBuilder.append("<font ");
                                            if (font2.getFontName() != null) {
                                                richTextBuilder.append("face='" + font2.getFontName() + "' ");
                                            }
                                            if (textStyle.getFontColor() != null) {
                                                String hex = String.format("#%02x%02x%02x", textStyle.getFontColor().getRed(), textStyle.getFontColor().getGreen(), textStyle.getFontColor().getBlue());
                                                richTextBuilder.append("color='" + hex + "' ");
                                            }
                                            richTextBuilder.append(">");
                                            richTextBuilder.append(subtext.replace("\n", "<br>"));
                                            richTextBuilder.append("</font>");
                                            if (underline) {
                                                richTextBuilder.append("</u>");
                                            }
                                            if (font2.getStrikeout()) {
                                                richTextBuilder.append("</strike>");
                                            }
                                            if (font2.getItalic()) {
                                                richTextBuilder.append("</i>");
                                            }
                                            if (font2.getBold()) {
                                                richTextBuilder.append("</b>");
                                            }
                                        } else {
                                            richTextBuilder.append(subtext.replace("\n", "<br>"));
                                        }
                                        textStyleBuffer.add(textStyle);
                                    }
                                }
                                excelCell.setValueRichText(richTextBuilder.toString());
                                break;
                            }
                            case FORMULA: {
                                try {
                                    excelCell.setValueFormular(cell.getCellFormula());
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                formularCellType = cell.getCachedFormulaResultTypeEnum();
                                break;
                            }
                            case ERROR: {
                                excelCell.setValueError(cell.getErrorCellValue());
                            }
                        }
                        excelCell.setRow(cell.getAddress().getRow());
                        excelCell.setColumn(cell.getAddress().getColumn());
                        excelCell.setAddress(cell.getAddress().toString());
                        if (formularCellType != null) {
                            excelCell.setCellTypeFormular(formularCellType.toString().toLowerCase());
                            switch (formularCellType) {
                                case NUMERIC: {
                                    excelCell.setValueNumeric(cell.getNumericCellValue());
                                    break;
                                }
                                case BOOLEAN: {
                                    excelCell.setValueBoolean(cell.getBooleanCellValue());
                                    break;
                                }
                                case STRING: {
                                    excelCell.setValueString(cell.getStringCellValue());
                                }
                            }
                        }
                        listener.setCurrent(runningCellNumber++);
                        if (cellBuffer.size() >= 10000) {
                            to.addCellBulk(cellBuffer);
                            cellBuffer.clear();
                        }
                        if (textStyleBuffer.size() < 10000) continue;
                        to.addTextStyleBulk(textStyleBuffer);
                        textStyleBuffer.clear();
                    }
                }
                to.addCellBulk(cellBuffer);
                cellBuffer.clear();
                to.addTextStyleBulk(textStyleBuffer);
                textStyleBuffer.clear();
            }
            workbook.close();
            System.gc();
        }
        to.addBulk(sheetBuffer);
        sheetBuffer.clear();
    }

    @Override
    public TableModel preview(DataStoreDescription from) {
        return null;
    }

    @Override
    public Preference getPreference() {
        return new Preference();
    }

    @Override
    public String getName() {
        return "Excel";
    }

    @Override
    public DataModel getDataModel() {
        return DataModel.Relational;
    }
}

