/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.hephaistos.storage.excel;

import de.dfki.sds.hephaistos.storage.InternalStorageMetaData;
import de.dfki.sds.hephaistos.storage.RelationalStorage;
import de.dfki.sds.hephaistos.storage.StorageSummary;
import de.dfki.sds.hephaistos.storage.excel.ExcelCell;
import de.dfki.sds.hephaistos.storage.excel.ExcelSheet;
import de.dfki.sds.hephaistos.storage.excel.ExcelTextStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class ExcelStorage
extends RelationalStorage<ExcelSheet, StorageSummary> {
    public ExcelStorage(InternalStorageMetaData metaData) {
        super(metaData);
    }

    public abstract void addCellBulk(Collection<ExcelCell> var1);

    public abstract void addTextStyleBulk(Collection<ExcelTextStyle> var1);

    public abstract void removeCellBulk(Collection<ExcelCell> var1);

    public abstract void removeTextStyleBulk(Collection<ExcelTextStyle> var1);

    public abstract Iterable<ExcelCell> getCellListIter(ExcelSheet var1);

    public abstract Iterable<ExcelTextStyle> getTextStyleListIter(ExcelCell var1);

    public abstract ExcelSheet getSheet(int var1);

    public abstract ExcelCell getCell(int var1);

    public List<ExcelCell> getCellList(ExcelSheet sheet) {
        ArrayList<ExcelCell> result = new ArrayList<ExcelCell>();
        this.getCellListIter(sheet).forEach(result::add);
        return result;
    }

    public List<ExcelTextStyle> getTextStyleList(ExcelCell cell) {
        ArrayList<ExcelTextStyle> result = new ArrayList<ExcelTextStyle>();
        this.getTextStyleListIter(cell).forEach(result::add);
        return result;
    }

    @Deprecated
    public List<ExcelCell> getColumn(ExcelSheet sheet, int greaterEqualRow, int equalColumn) {
        ArrayList<ExcelCell> result = new ArrayList<ExcelCell>();
        this.getCellListIter(sheet).forEach(c -> {
            if (c.getRow() >= greaterEqualRow && c.getColumn() == equalColumn) {
                result.add((ExcelCell)c);
            }
        });
        return result;
    }

    public abstract List<ExcelCell> getRow(ExcelSheet var1, int var2, int var3);

    @Deprecated
    public ExcelCell getCell(ExcelSheet sheet, int equalRow, int equalColumn) {
        for (ExcelCell cell : this.getCellListIter(sheet)) {
            if (cell.getRow() != equalRow || cell.getColumn() != equalColumn) continue;
            return cell;
        }
        return null;
    }
}

