/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.hephaistos.storage.excel;

import de.dfki.sds.hephaistos.storage.StorageItem;
import java.awt.Color;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.json.JSONObject;

public class ExcelCell
implements StorageItem {
    private String deepLink;
    private int id;
    private int sheetId;
    private int row;
    private int column;
    private String address;
    private boolean fontBold;
    private boolean fontItalic;
    private boolean fontStrikeout;
    private boolean fontUnderline;
    private int fontSize;
    private String fontName;
    private Color fontColor;
    private Color foregroundColor;
    private Color backgroundColor;
    private int rotation;
    private String horizontalAlignment;
    private String verticalAlignment;
    private String borderTop;
    private String borderLeft;
    private String borderRight;
    private String borderBottom;
    private String cellType;
    private String cellTypeFormular;
    private String dataFormat;
    private double valueNumeric;
    private boolean valueBoolean;
    private String valueFormular;
    private int valueError;
    private String valueString;
    private String valueRichText;
    private static final DataFormatter dataFormatter = new DataFormatter();

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + this.id;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExcelCell other = (ExcelCell)obj;
        return this.id == other.id;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getSheetId() {
        return this.sheetId;
    }

    public void setSheetId(int sheetId) {
        this.sheetId = sheetId;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public boolean isFontBold() {
        return this.fontBold;
    }

    public void setFontBold(boolean fontBold) {
        this.fontBold = fontBold;
    }

    public boolean isFontItalic() {
        return this.fontItalic;
    }

    public void setFontItalic(boolean fontItalic) {
        this.fontItalic = fontItalic;
    }

    public boolean isFontStrikeout() {
        return this.fontStrikeout;
    }

    public void setFontStrikeout(boolean fontStrikeout) {
        this.fontStrikeout = fontStrikeout;
    }

    public boolean isFontUnderline() {
        return this.fontUnderline;
    }

    public void setFontUnderline(boolean fontUnderline) {
        this.fontUnderline = fontUnderline;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(Color fontColor) {
        this.fontColor = fontColor;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public String getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(String horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public String getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(String verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public String getBorderTop() {
        return this.borderTop;
    }

    public void setBorderTop(String borderTop) {
        this.borderTop = borderTop;
    }

    public String getBorderLeft() {
        return this.borderLeft;
    }

    public void setBorderLeft(String borderLeft) {
        this.borderLeft = borderLeft;
    }

    public String getBorderRight() {
        return this.borderRight;
    }

    public void setBorderRight(String borderRight) {
        this.borderRight = borderRight;
    }

    public String getBorderBottom() {
        return this.borderBottom;
    }

    public void setBorderBottom(String borderBottom) {
        this.borderBottom = borderBottom;
    }

    public String getCellType() {
        return this.cellType;
    }

    public void setCellType(String cellType) {
        this.cellType = cellType;
    }

    public String getCellTypeFormular() {
        return this.cellTypeFormular;
    }

    public void setCellTypeFormular(String cellTypeFormular) {
        this.cellTypeFormular = cellTypeFormular;
    }

    public double getValueNumeric() {
        return this.valueNumeric;
    }

    public void setValueNumeric(double valueNumeric) {
        this.valueNumeric = valueNumeric;
    }

    public boolean getValueBoolean() {
        return this.valueBoolean;
    }

    public void setValueBoolean(boolean valueBoolean) {
        this.valueBoolean = valueBoolean;
    }

    public String getValueFormular() {
        return this.valueFormular;
    }

    public void setValueFormular(String valueFormular) {
        this.valueFormular = valueFormular;
    }

    public int getValueError() {
        return this.valueError;
    }

    public void setValueError(int valueError) {
        this.valueError = valueError;
    }

    public String getValueString() {
        return this.valueString;
    }

    public void setValueString(String valueString) {
        this.valueString = valueString;
    }

    public String getValueRichText() {
        return this.valueRichText;
    }

    public void setValueRichText(String valueRichText) {
        this.valueRichText = valueRichText;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
    }

    public String getValueNumericFormatted() {
        try {
            return dataFormatter.formatRawCellContents(this.valueNumeric, 0, this.dataFormat);
        }
        catch (Exception e2) {
            return null;
        }
    }

    public String toString() {
        return "ExcelCell{id=" + this.id + ", sheetId=" + this.sheetId + ", row=" + this.row + ", column=" + this.column + ", address=" + this.address + ", cellType=" + this.cellType + ", valueNumeric=" + this.valueNumeric + ", dataFormat=" + this.dataFormat + ", valueNumericFormatted=" + this.getValueNumericFormatted() + ", valueBoolean=" + this.valueBoolean + ", valueFormular=" + this.valueFormular + ", valueError=" + this.valueError + ", valueString=" + this.valueString + '}';
    }

    public String getValue() {
        if (this.cellType.equals("numeric")) {
            if (this.getValueNumeric() % 1.0 == 0.0) {
                return String.valueOf((int)this.getValueNumeric());
            }
            return String.valueOf(this.getValueNumeric());
        }
        if (this.cellType.equals("boolean")) {
            return String.valueOf(this.getValueBoolean());
        }
        if (this.cellType.equals("formular")) {
            return String.valueOf(this.getValueFormular());
        }
        if (this.cellType.equals("error")) {
            return String.valueOf(this.getValueError());
        }
        if (this.cellType.equals("string")) {
            return String.valueOf(this.getValueString());
        }
        return "";
    }

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put("row", this.row);
        json.put("column", this.column);
        json.put("address", this.address);
        json.put("cellType", this.cellType);
        json.put("cellTypeFormular", this.cellTypeFormular);
        json.put("valueNumeric", this.valueNumeric);
        json.put("valueBoolean", this.valueBoolean);
        json.put("valueFormular", this.valueFormular);
        json.put("valueError", this.valueError);
        json.put("valueString", this.valueString);
        json.put("valueRichText", this.valueRichText);
        return json;
    }
}

