/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.hephaistos.storage.assertion;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;

public class Counter {
    private File folder;
    private static Counter singleton;

    public Counter(File folder) {
        this.folder = folder;
        folder.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(String name) {
        Counter counter = this;
        synchronized (counter) {
            File counterFile = new File(this.folder, name + ".txt");
            counterFile.delete();
        }
    }

    public int getIncreased(String name) {
        Counter counter = this;
        synchronized (counter) {
            try {
                int count;
                File counterFile = new File(this.folder, name + ".txt");
                if (!counterFile.exists()) {
                    FileUtils.writeStringToFile(counterFile, "1", StandardCharsets.UTF_8);
                }
                try {
                    count = Integer.parseInt(FileUtils.readFileToString(counterFile, StandardCharsets.UTF_8).trim());
                }
                catch (NumberFormatException e2) {
                    count = 1;
                }
                int inc = count + 1;
                FileUtils.writeStringToFile(counterFile, String.valueOf(inc), StandardCharsets.UTF_8);
                return count;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @Deprecated
    public static Counter getSingleton() {
        if (singleton == null) {
            singleton = new Counter(new File("results/counter"));
        }
        return singleton;
    }
}

