/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.hephaistos.storage.assertion;

import de.dfki.sds.hephaistos.storage.InternalStorageMetaData;
import de.dfki.sds.hephaistos.storage.SQLiteUtility;
import de.dfki.sds.hephaistos.storage.StorageSummary;
import de.dfki.sds.hephaistos.storage.assertion.Assertion;
import de.dfki.sds.hephaistos.storage.assertion.AssertionPool;
import de.dfki.sds.hephaistos.storage.assertion.Intelligence;
import de.dfki.sds.hephaistos.storage.assertion.Opinion;
import de.dfki.sds.hephaistos.storage.assertion.Phase;
import de.dfki.sds.hephaistos.storage.assertion.Rating;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.impl.LiteralImpl;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.json.JSONObject;

public class AssertionPoolSqlite
extends AssertionPool {
    private Connection connection;
    private String tablename;
    private static final String QUERY_PATH = "/de/dfki/sds/hephaistos/storage/assertion/";
    private String upsertQuery;
    private PreparedStatement[] preparedStatements;
    private File folder;
    private static final Object syncPoint = new Object();

    public AssertionPoolSqlite(InternalStorageMetaData metaData, Connection connection, File folder) {
        super(metaData, folder);
        this.connection = connection;
        this.folder = folder;
        this.tablename = metaData.getId();
        SQLiteUtility.execute(connection, this.getQuery("/de/dfki/sds/hephaistos/storage/assertion/CreateTableAssertion.sql"));
        SQLiteUtility.execute(connection, this.getQuery("/de/dfki/sds/hephaistos/storage/assertion/CreateIndexSP.sql"));
        SQLiteUtility.execute(connection, this.getQuery("/de/dfki/sds/hephaistos/storage/assertion/CreateIndexPO.sql"));
        SQLiteUtility.execute(connection, this.getQuery("/de/dfki/sds/hephaistos/storage/assertion/CreateIndexP.sql"));
        this.upsertQuery = this.getQuery("/de/dfki/sds/hephaistos/storage/assertion/UpsertAssertion.sql");
        SQLiteUtility.run(connection, c -> c.setAutoCommit(false));
        this.preparedStatements = new PreparedStatement[2];
    }

    @Override
    public void clear() {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public void remove() {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public StorageSummary summary() {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public long size() {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public void close() {
    }

    @Override
    public List<Assertion> getAssertions(Resource subject, Property predicate, RDFNode object, Phase phase, Intelligence intel, String name, Rating rating, double confidenceThreshold) {
        boolean opinionPartNeed;
        StringBuilder querySB = new StringBuilder();
        querySB.append("SELECT * FROM \"Assertion\"\n");
        querySB.append("WHERE\n");
        StringJoiner whereJoiner = new StringJoiner(" AND ");
        if (subject != null) {
            whereJoiner.add("s = ?");
        }
        if (predicate != null) {
            whereJoiner.add("p = ?");
        }
        if (object != null) {
            whereJoiner.add("o = ?");
        }
        if (phase != null) {
            whereJoiner.add("phase = ?");
        }
        boolean bl = opinionPartNeed = intel != null || name != null || rating != null || confidenceThreshold > 0.0;
        if (opinionPartNeed) {
            LinkedHashMap<String, StringJoiner> m = new LinkedHashMap<String, StringJoiner>();
            m.put("ni_", new StringJoiner(" AND "));
            m.put("ai_", new StringJoiner(" AND "));
            ArrayList<String> prefixes = new ArrayList<String>(Arrays.asList("ni_", "ai_"));
            if (intel != null) {
                if (intel == Intelligence.AI) {
                    prefixes.remove("ni_");
                    m.remove("ni_");
                } else if (intel == Intelligence.NI) {
                    prefixes.remove("ai_");
                    m.remove("ai_");
                }
            }
            StringJoiner orJoiner = new StringJoiner(" OR ", "(", ")");
            for (Map.Entry entry : m.entrySet()) {
                String prefix = (String)entry.getKey();
                StringJoiner joiner = (StringJoiner)entry.getValue();
                if (prefix.equals("ni_")) {
                    joiner.add("ni_intelligence IS NOT NULL");
                } else if (prefix.equals("ai_")) {
                    joiner.add("ni_intelligence IS NULL AND ai_intelligence IS NOT NULL");
                }
                if (name != null) {
                    joiner.add(prefix + "name = ?");
                }
                if (rating != null) {
                    joiner.add(prefix + "rating = ?");
                }
                if (confidenceThreshold > 0.0) {
                    joiner.add(prefix + "confidence >= ?");
                }
                orJoiner.add(((StringJoiner)entry.getValue()).toString());
            }
            whereJoiner.add(orJoiner.toString());
        }
        querySB.append(whereJoiner.toString());
        return SQLiteUtility.supply(this.connection, c -> {
            ArrayList<Assertion> assertions = new ArrayList<Assertion>();
            PreparedStatement pstmt = c.prepareStatement(querySB.toString());
            int paramIndex = 1;
            if (subject != null) {
                pstmt.setString(paramIndex++, subject.getURI());
            }
            if (predicate != null) {
                pstmt.setString(paramIndex++, predicate.getURI());
            }
            if (object != null) {
                pstmt.setString(paramIndex++, AssertionPoolSqlite.toString(object));
            }
            if (phase != null) {
                pstmt.setString(paramIndex++, phase.toString());
            }
            for (int i = 0; i < (intel == null ? 2 : 1); ++i) {
                if (name != null) {
                    pstmt.setString(paramIndex++, name);
                }
                if (rating != null) {
                    pstmt.setString(paramIndex++, rating.toString());
                }
                if (!(confidenceThreshold > 0.0)) continue;
                pstmt.setDouble(paramIndex++, confidenceThreshold);
            }
            ResultSet rs = pstmt.executeQuery();
            ArrayList<String> prefixes = new ArrayList<String>(Arrays.asList("ni_", "ai_"));
            while (rs.next()) {
                Assertion assertion = new Assertion();
                Statement stmt = AssertionPoolSqlite.toStatement(new String[]{rs.getString("s"), rs.getString("p"), rs.getString("o")});
                assertion.setStatement(stmt);
                assertion.setPhase(Phase.valueOf(rs.getString("phase")));
                for (String prefix : prefixes) {
                    if (rs.getString(prefix + "intelligence") == null) continue;
                    Opinion opinion = new Opinion();
                    opinion.setIntelligence(prefix.equals("ni_") ? Intelligence.NI : Intelligence.AI);
                    opinion.setName(rs.getString(prefix + "name"));
                    opinion.setRating(Rating.valueOf(rs.getString(prefix + "rating")));
                    opinion.setConfidence(rs.getDouble(prefix + "confidence"));
                    opinion.setWhen(LocalDateTime.ofEpochSecond(rs.getLong(prefix + "when"), 0, ZoneOffset.ofHours(0)));
                    assertion.setOpinion(opinion);
                }
                assertions.add(assertion);
            }
            rs.close();
            pstmt.close();
            return assertions;
        });
    }

    public long getCount(Resource subject, Property predicate, RDFNode object, Phase phase, Intelligence intel, String name, Rating rating, double confidenceThreshold) {
        boolean opinionPartNeed;
        StringBuilder querySB = new StringBuilder();
        querySB.append("SELECT COUNT(*) FROM \"Assertion\"\n");
        querySB.append("WHERE\n");
        StringJoiner whereJoiner = new StringJoiner(" AND ");
        if (subject != null) {
            whereJoiner.add("s = ?");
        }
        if (predicate != null) {
            whereJoiner.add("p = ?");
        }
        if (object != null) {
            whereJoiner.add("o = ?");
        }
        if (phase != null) {
            whereJoiner.add("phase = ?");
        }
        boolean bl = opinionPartNeed = intel != null || name != null || rating != null || confidenceThreshold > 0.0;
        if (opinionPartNeed) {
            LinkedHashMap<String, StringJoiner> m = new LinkedHashMap<String, StringJoiner>();
            m.put("ni_", new StringJoiner(" AND "));
            m.put("ai_", new StringJoiner(" AND "));
            ArrayList<String> prefixes = new ArrayList<String>(Arrays.asList("ni_", "ai_"));
            if (intel != null) {
                if (intel == Intelligence.AI) {
                    prefixes.remove("ni_");
                    m.remove("ni_");
                } else if (intel == Intelligence.NI) {
                    prefixes.remove("ai_");
                    m.remove("ai_");
                }
            }
            StringJoiner orJoiner = new StringJoiner(" OR ", "(", ")");
            for (Map.Entry entry : m.entrySet()) {
                String prefix = (String)entry.getKey();
                StringJoiner joiner = (StringJoiner)entry.getValue();
                if (prefix.equals("ni_")) {
                    joiner.add("ni_intelligence IS NOT NULL");
                } else if (prefix.equals("ai_")) {
                    joiner.add("ni_intelligence IS NULL AND ai_intelligence IS NOT NULL");
                }
                if (name != null) {
                    joiner.add(prefix + "name = ?");
                }
                if (rating != null) {
                    joiner.add(prefix + "rating = ?");
                }
                if (confidenceThreshold > 0.0) {
                    joiner.add(prefix + "confidence >= ?");
                }
                orJoiner.add(((StringJoiner)entry.getValue()).toString());
            }
            whereJoiner.add(orJoiner.toString());
        }
        querySB.append(whereJoiner.toString());
        return SQLiteUtility.supply(this.connection, c -> {
            PreparedStatement pstmt = c.prepareStatement(querySB.toString());
            int paramIndex = 1;
            if (subject != null) {
                pstmt.setString(paramIndex++, subject.getURI());
            }
            if (predicate != null) {
                pstmt.setString(paramIndex++, predicate.getURI());
            }
            if (object != null) {
                pstmt.setString(paramIndex++, AssertionPoolSqlite.toString(object));
            }
            if (phase != null) {
                pstmt.setString(paramIndex++, phase.toString());
            }
            for (int i = 0; i < (intel == null ? 2 : 1); ++i) {
                if (name != null) {
                    pstmt.setString(paramIndex++, name);
                }
                if (rating != null) {
                    pstmt.setString(paramIndex++, rating.toString());
                }
                if (!(confidenceThreshold > 0.0)) continue;
                pstmt.setDouble(paramIndex++, confidenceThreshold);
            }
            ResultSet rs = pstmt.executeQuery();
            long count = -1L;
            if (rs.next()) {
                count = rs.getLong(1);
            }
            rs.close();
            pstmt.close();
            return count;
        });
    }

    @Override
    public List<Assertion> getAssertionsIn(Property predicate, List<RDFNode> objects, Phase phase) {
        StringBuilder querySB = new StringBuilder();
        querySB.append("SELECT * FROM \"Assertion\"\n");
        querySB.append("WHERE\n");
        StringJoiner whereJoiner = new StringJoiner(" AND ");
        if (predicate != null) {
            whereJoiner.add("p = ?");
        }
        if (phase != null) {
            whereJoiner.add("phase = ?");
        }
        StringJoiner inJoiner = new StringJoiner(",", "(", ")");
        for (RDFNode node : objects) {
            inJoiner.add("?");
        }
        whereJoiner.add("o IN " + inJoiner.toString());
        querySB.append(whereJoiner.toString());
        return SQLiteUtility.supply(this.connection, c -> {
            ArrayList<Assertion> assertions = new ArrayList<Assertion>();
            PreparedStatement pstmt = c.prepareStatement(querySB.toString());
            int paramIndex = 1;
            if (predicate != null) {
                pstmt.setString(paramIndex++, predicate.getURI());
            }
            if (phase != null) {
                pstmt.setString(paramIndex++, phase.toString());
            }
            for (RDFNode object : objects) {
                pstmt.setString(paramIndex++, AssertionPoolSqlite.toString(object));
            }
            ResultSet rs = pstmt.executeQuery();
            ArrayList<String> prefixes = new ArrayList<String>(Arrays.asList("ni_", "ai_"));
            while (rs.next()) {
                Assertion assertion = new Assertion();
                Statement stmt = AssertionPoolSqlite.toStatement(new String[]{rs.getString("s"), rs.getString("p"), rs.getString("o")});
                assertion.setStatement(stmt);
                assertion.setPhase(Phase.valueOf(rs.getString("phase")));
                for (String prefix : prefixes) {
                    if (rs.getString(prefix + "intelligence") == null) continue;
                    Opinion opinion = new Opinion();
                    opinion.setIntelligence(prefix.equals("ni_") ? Intelligence.NI : Intelligence.AI);
                    opinion.setName(rs.getString(prefix + "name"));
                    opinion.setRating(Rating.valueOf(rs.getString(prefix + "rating")));
                    opinion.setConfidence(rs.getDouble(prefix + "confidence"));
                    opinion.setWhen(LocalDateTime.ofEpochSecond(rs.getLong(prefix + "when"), 0, ZoneOffset.ofHours(0)));
                    assertion.setOpinion(opinion);
                }
                assertions.add(assertion);
            }
            rs.close();
            pstmt.close();
            return assertions;
        });
    }

    @Override
    protected void assertStatement(Statement stmt, Phase phase, Intelligence intel, String name, Rating rating, double confidence, LocalDateTime when) {
        if (stmt == null || phase == null || intel == null || name == null || rating == null) {
            throw new RuntimeException("assertStatement null detected: " + Arrays.asList(new Object[]{stmt, phase, intel, name, rating}));
        }
        boolean notify = false;
        if (!this.bulkMode) {
            List<Assertion> exists = this.getAssertions(stmt.getSubject(), stmt.getPredicate(), stmt.getObject(), phase, intel, name, rating, confidence);
            notify = exists.isEmpty();
        }
        if (notify) {
            Assertion assertion = new Assertion();
            assertion.setStatement(stmt);
            assertion.setPhase(phase);
            assertion.setOpinion(intel, name, when, rating, confidence);
            if (this.isLogging()) {
                this.saveAssertion(assertion, this.folder);
            }
            this.commitBuffer.add(assertion);
        }
        String query = this.upsertQuery.replace("${prefix}", intel == Intelligence.AI ? "ai_" : "ni_");
        if (this.preparedStatements[intel.ordinal()] == null) {
            this.preparedStatements[intel.ordinal()] = SQLiteUtility.supply(this.connection, c -> c.prepareStatement(query));
        }
        PreparedStatement preparedStatement = this.preparedStatements[intel.ordinal()];
        SQLiteUtility.run(this.connection, c -> {
            this.setParametersNull(preparedStatement);
            String[] array = AssertionPoolSqlite.toStringArray(stmt);
            preparedStatement.setString(1, array[0]);
            preparedStatement.setString(2, array[1]);
            preparedStatement.setString(3, array[2]);
            preparedStatement.setString(4, phase.toString());
            int paramIndex = intel == Intelligence.AI ? 5 : 10;
            preparedStatement.setString(paramIndex + 0, intel.toString());
            preparedStatement.setString(paramIndex + 1, name);
            preparedStatement.setString(paramIndex + 2, rating.toString());
            preparedStatement.setDouble(paramIndex + 3, confidence);
            preparedStatement.setLong(paramIndex + 4, when.toEpochSecond(ZoneOffset.ofHours(0)));
            preparedStatement.setString(15, intel.toString());
            preparedStatement.setString(16, name);
            preparedStatement.setString(17, rating.toString());
            preparedStatement.setDouble(18, confidence);
            preparedStatement.setLong(19, when.toEpochSecond(ZoneOffset.ofHours(0)));
            preparedStatement.addBatch();
        });
    }

    @Override
    public void removeAllAbout(Resource resource) {
        String query = this.getQuery("/de/dfki/sds/hephaistos/storage/assertion/DeleteAssertion.sql");
        SQLiteUtility.run(this.connection, c -> {
            PreparedStatement pstmt = c.prepareStatement(query);
            pstmt.setString(1, resource.getURI());
            pstmt.setString(2, "<" + resource.getURI() + ">");
            pstmt.executeUpdate();
            pstmt.close();
            c.commit();
        });
    }

    private void setParametersNull(PreparedStatement ps) throws SQLException {
        for (int i = 0; i < ps.getParameterMetaData().getParameterCount(); ++i) {
            if (ps.getParameterMetaData().isNullable(i + 1) != 1) continue;
            ps.setNull(i + 1, 1111);
        }
    }

    @Override
    public void commit() {
        if (this.preparedStatements[Intelligence.AI.ordinal()] != null || this.preparedStatements[Intelligence.NI.ordinal()] != null) {
            SQLiteUtility.run(this.connection, c -> {
                for (Intelligence intel : Intelligence.values()) {
                    if (this.preparedStatements[intel.ordinal()] == null) continue;
                    this.preparedStatements[intel.ordinal()].executeBatch();
                }
                c.commit();
                for (Intelligence intel : Intelligence.values()) {
                    if (this.preparedStatements[intel.ordinal()] == null) continue;
                    this.preparedStatements[intel.ordinal()].close();
                    this.preparedStatements[intel.ordinal()] = null;
                }
            });
            this.notificationBuffer.addAll(this.commitBuffer);
            this.commitBuffer.clear();
        }
    }

    @Override
    public void rollback() {
        if (this.preparedStatements[Intelligence.AI.ordinal()] != null || this.preparedStatements[Intelligence.NI.ordinal()] != null) {
            SQLiteUtility.run(this.connection, c -> {
                for (Intelligence intel : Intelligence.values()) {
                    if (this.preparedStatements[intel.ordinal()] == null) continue;
                    this.preparedStatements[intel.ordinal()].close();
                    this.preparedStatements[intel.ordinal()] = null;
                }
                c.rollback();
            });
            this.commitBuffer.clear();
        }
    }

    private String getQuery(String path) {
        try {
            String query = IOUtils.toString(this.getClass().getResourceAsStream(path), StandardCharsets.UTF_8);
            query = query.replace("${tablename}", this.tablename);
            return query;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private File getSqliteFile(File folder) {
        return new File(folder, "data.sqlite");
    }

    private static String[] toStringArray(Statement stmt) {
        return new String[]{stmt.getSubject().getURI(), stmt.getPredicate().getURI(), AssertionPoolSqlite.toString(stmt.getObject())};
    }

    private static String toString(RDFNode rdfNode) {
        boolean r = rdfNode.isResource();
        return (r ? "<" : "") + rdfNode.asNode().toString(true) + (r ? ">" : "");
    }

    private static Statement toStatement(String[] array) {
        Node obj = NodeFactoryExtra.parseNode(array[2]);
        Statement stmt = ResourceFactory.createStatement(ResourceFactory.createResource(array[0]), ResourceFactory.createProperty(array[1]), AssertionPoolSqlite.toRDFNode(obj));
        return stmt;
    }

    private static RDFNode toRDFNode(Node node) {
        if (node.isLiteral()) {
            return new LiteralImpl(node, null);
        }
        return new ResourceImpl(node, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAssertion(Assertion assertion, File folder) {
        JSONObject entry = Assertion.toJson(assertion);
        entry.put("saveTime", LocalDateTime.now());
        String name = this.metaData.getId() + "-log.jsonl.gz";
        Object object = syncPoint;
        synchronized (object) {
            File file = new File(folder, name);
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            try {
                GZIPOutputStream os = new GZIPOutputStream(new FileOutputStream(file, true));
                String line = entry.toString() + "\n";
                ((OutputStream)os).write(line.getBytes(StandardCharsets.UTF_8));
                ((OutputStream)os).close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

