/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.hephaistos.storage.assertion;

import de.dfki.sds.hephaistos.storage.InternalStorage;
import de.dfki.sds.hephaistos.storage.InternalStorageMetaData;
import de.dfki.sds.hephaistos.storage.StorageSummary;
import de.dfki.sds.hephaistos.storage.assertion.Assertion;
import de.dfki.sds.hephaistos.storage.assertion.AssertionListener;
import de.dfki.sds.hephaistos.storage.assertion.Concept;
import de.dfki.sds.hephaistos.storage.assertion.Counter;
import de.dfki.sds.hephaistos.storage.assertion.Intelligence;
import de.dfki.sds.hephaistos.storage.assertion.Phase;
import de.dfki.sds.hephaistos.storage.assertion.Rating;
import de.dfki.sds.hephaistos.storage.file.FileInfoStorage;
import java.io.File;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.Function;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.sparql.vocabulary.FOAF;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.SKOS;

public abstract class AssertionPool
extends InternalStorage<Assertion, StorageSummary, Object> {
    private static final Model creator = ModelFactory.createDefaultModel();
    private List<AssertionListener> listeners;
    protected List<Assertion> notificationBuffer;
    private final int notifyRecursionThreshold = 100;
    protected List<Assertion> commitBuffer = new ArrayList<Assertion>();
    protected boolean bulkMode;
    private boolean print = false;
    private boolean logging = true;
    private File folder;
    private Counter counter;

    public AssertionPool(InternalStorageMetaData metaData, File folder) {
        super(metaData);
        this.folder = folder;
        this.counter = new Counter(new File(folder, "counters"));
        this.listeners = new ArrayList<AssertionListener>();
        this.notificationBuffer = new ArrayList<Assertion>();
    }

    public void addListener(AssertionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(AssertionListener listener) {
        this.listeners.remove(listener);
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    public void notifyListenersRecursively(FileInfoStorage fileInfoStorage) {
        this.notifyListenersRecursively(fileInfoStorage, 0);
    }

    private void notifyListenersRecursively(FileInfoStorage fileInfoStorage, int depth) {
        if (depth >= 100) {
            this.clearNotificationBuffer();
            throw new StackOverflowError("ERROR: notifyListenersRecursively stopped because recursion is too deep");
        }
        if (this.notificationBuffer.isEmpty()) {
            return;
        }
        if (this.print) {
            System.out.println("========================");
            System.out.println("notifyListenersRecursively depth: " + depth);
            System.out.println("========================");
        }
        ArrayList<Assertion> copy = new ArrayList<Assertion>(this.notificationBuffer);
        this.clearNotificationBuffer();
        for (AssertionListener al : this.listeners) {
            al.updateOnChanges(fileInfoStorage, this, copy);
        }
        this.commit();
        if (!this.notificationBuffer.isEmpty()) {
            this.notifyListenersRecursively(fileInfoStorage, depth + 1);
        }
    }

    public void clearNotificationBuffer() {
        this.notificationBuffer.clear();
    }

    protected abstract void assertStatement(Statement var1, Phase var2, Intelligence var3, String var4, Rating var5, double var6, LocalDateTime var8);

    public void assertStatement(Statement stmt, Phase phase, Intelligence intel, String name, Rating rating, double confidence) {
        this.assertStatement(stmt, phase, intel, name, rating, confidence, LocalDateTime.now());
    }

    public void assertAssertion(Assertion assertion) {
        this.assertStatement(assertion.getStatement(), assertion.getPhase(), assertion.getIntelligence(), assertion.getName(), assertion.getRating(), assertion.getConfidence());
    }

    public void assertAssertionTimePreserving(Assertion assertion) {
        this.assertStatement(assertion.getStatement(), assertion.getPhase(), assertion.getIntelligence(), assertion.getName(), assertion.getRating(), assertion.getConfidence(), assertion.getWhen());
    }

    public void assertStatement(Resource subject, Property predicate, RDFNode object, Phase phase, Intelligence intel, String name, Rating rating, double confidence) {
        this.assertStatement(creator.createStatement(subject, predicate, object), phase, intel, name, rating, confidence);
    }

    public void assertStatement(Resource subject, Property predicate, String plainLiteral, Phase phase, Intelligence intel, String name, Rating rating, double confidence) {
        this.assertStatement(creator.createStatement(subject, predicate, creator.createLiteral(plainLiteral)), phase, intel, name, rating, confidence);
    }

    public void assertLiteralStatement(String subjectUri, String predicateUri, String plainLiteral, Phase phase, Intelligence intel, String name, Rating rating, double confidence) {
        this.assertStatement(creator.createStatement(creator.createResource(subjectUri), creator.getProperty(predicateUri), creator.createLiteral(plainLiteral)), phase, intel, name, rating, confidence);
    }

    public void assertResourceStatement(String subjectUri, String predicateUri, String objectUri, Phase phase, Intelligence intel, String name, Rating rating, double confidence) {
        this.assertStatement(creator.createStatement(creator.createResource(subjectUri), creator.getProperty(predicateUri), creator.createResource(objectUri)), phase, intel, name, rating, confidence);
    }

    public abstract void removeAllAbout(Resource var1);

    public Resource createConcept() {
        return creator.createResource("urn:concept:" + this.counter.getIncreased("concept"));
    }

    public Resource createType() {
        return creator.createResource("urn:type:" + this.counter.getIncreased("type"));
    }

    public Resource createProperty() {
        return creator.createResource("urn:property:" + this.counter.getIncreased("property"));
    }

    public abstract List<Assertion> getAssertions(Resource var1, Property var2, RDFNode var3, Phase var4, Intelligence var5, String var6, Rating var7, double var8);

    public abstract List<Assertion> getAssertionsIn(Property var1, List<RDFNode> var2, Phase var3);

    @Deprecated
    public List<Assertion> getAssertionsViaSubjects(List<Assertion> inputAssertions, Function<Assertion, Resource> toSubject, Property predicate, RDFNode object, Phase phase, Intelligence intel, String name, Rating rating, double confidenceThreshold) {
        ArrayList<Assertion> l = new ArrayList<Assertion>();
        for (Assertion inputAs : inputAssertions) {
            l.addAll(this.getAssertions(toSubject.apply(inputAs), predicate, object, phase, intel, name, rating, confidenceThreshold));
        }
        return l;
    }

    @Deprecated
    public List<Assertion> getAssertionsViaObjects(List<Assertion> inputAssertions, Function<Assertion, RDFNode> toObject, Resource Subject, Property predicate, Phase phase, Intelligence intel, String name, Rating rating, double confidenceThreshold) {
        ArrayList<Assertion> l = new ArrayList<Assertion>();
        for (Assertion inputAs : inputAssertions) {
            l.addAll(this.getAssertions(Subject, predicate, toObject.apply(inputAs), phase, intel, name, rating, confidenceThreshold));
        }
        return l;
    }

    public List<Concept> getConcepts() {
        return this.getConcepts(false);
    }

    public List<Concept> getConcepts(boolean alsoNegative) {
        ArrayList<Concept> concepts = new ArrayList<Concept>();
        Rating ratingFilter = alsoNegative ? null : Rating.Positive;
        List<Assertion> conceptAssertions = this.getAssertions(null, RDF.type, OWL2.NamedIndividual, Phase.ConceptDiscovery, null, null, ratingFilter, 0.0);
        for (Assertion conceptAssertion : conceptAssertions) {
            concepts.add(this.getConcept(conceptAssertion));
        }
        return concepts;
    }

    public Assertion getConceptAssertion(Resource concept) {
        List<Assertion> conceptAssertions = this.getAssertions(concept, RDF.type, OWL2.NamedIndividual, Phase.ConceptDiscovery, null, null, null, 0.0);
        if (!conceptAssertions.isEmpty()) {
            return conceptAssertions.get(0);
        }
        return null;
    }

    public Concept getConcept(Assertion conceptAssertion) {
        List<Assertion> prefLabels = this.getAssertions(conceptAssertion.getSubject(), SKOS.prefLabel, null, Phase.ConceptDiscovery, null, null, null, 0.0);
        List<Assertion> hiddenLabels = this.getAssertions(conceptAssertion.getSubject(), SKOS.hiddenLabel, null, Phase.ConceptDiscovery, null, null, null, 0.0);
        hiddenLabels.sort((a, b) -> a.getStatement().getString().compareToIgnoreCase(b.getStatement().getString()));
        List<Assertion> types = this.getAssertions(conceptAssertion.getSubject(), RDF.type, null, Phase.ConceptDiscovery, null, null, null, 0.0);
        List<Assertion> isTopicOfs = this.getAssertions(conceptAssertion.getSubject(), null, FOAF.topic, Phase.ConceptDiscovery, null, null, null, 0.0);
        Concept concept = new Concept();
        concept.setPrefLabel(AssertionPool.getPrefLabelString(prefLabels));
        concept.setURI(conceptAssertion.getSubject().getURI());
        concept.setConceptAssertion(conceptAssertion);
        concept.setPrefLabels(prefLabels);
        concept.setHiddenLabels(hiddenLabels);
        concept.setTypes(types);
        concept.setIsTopicOfs(isTopicOfs);
        return concept;
    }

    public static String getPrefLabelString(List<Assertion> prefLabels) {
        String prefLabel = "";
        for (Assertion prefLabelAssertion : prefLabels) {
            if (prefLabelAssertion.getRating() != Rating.Positive) continue;
            prefLabel = prefLabelAssertion.getStatement().getString();
            break;
        }
        return prefLabel;
    }

    public Map<Resource, String> getTypePrefLabelMap() {
        HashMap<Resource, String> m = new HashMap<Resource, String>();
        List<Assertion> typeAssertions = this.getAssertions(null, RDF.type, RDFS.Class, Phase.OntologyPopulation, null, null, null, 0.0);
        for (Assertion typeAssertion : typeAssertions) {
            List<Assertion> prefLabels = this.getAssertions(typeAssertion.getSubject(), SKOS.prefLabel, null, Phase.OntologyPopulation, null, null, Rating.Positive, 0.0);
            if (prefLabels.isEmpty()) continue;
            m.put(typeAssertion.getSubject(), prefLabels.get(0).getStatement().getString());
        }
        return m;
    }

    public Map<Resource, String> getPropertyPrefLabelMap() {
        HashMap<Resource, String> m = new HashMap<Resource, String>();
        List<Assertion> propertyAssertions = this.getAssertions(null, RDF.type, RDF.Property, Phase.OntologyPopulation, null, null, null, 0.0);
        for (Assertion propertyAssertion : propertyAssertions) {
            List<Assertion> prefLabels = this.getAssertions(propertyAssertion.getSubject(), SKOS.prefLabel, null, Phase.OntologyPopulation, null, null, Rating.Positive, 0.0);
            if (prefLabels.isEmpty()) continue;
            m.put(propertyAssertion.getSubject(), prefLabels.get(0).getStatement().getString());
        }
        return m;
    }

    public Map<Resource, String> getConceptPrefLabelMap(Resource defaultType, Rating rating) {
        HashMap<Resource, String> m = new HashMap<Resource, String>();
        List<Assertion> conceptAssertions = this.getAssertions(null, RDF.type, defaultType, Phase.ConceptDiscovery, null, null, rating, 0.0);
        for (Assertion conceptAssertion : conceptAssertions) {
            List<Assertion> prefLabels = this.getAssertions(conceptAssertion.getSubject(), SKOS.prefLabel, null, Phase.ConceptDiscovery, null, null, Rating.Positive, 0.0);
            if (prefLabels.isEmpty()) continue;
            m.put(conceptAssertion.getSubject(), prefLabels.get(0).getStatement().getString());
        }
        return m;
    }

    public Map<String, List<Assertion>> getLabelConceptMap(Resource defaultType, boolean lowerCase) {
        HashMap<String, List<Assertion>> m = new HashMap<String, List<Assertion>>();
        List<Assertion> conceptAssertions = this.getAssertions(null, RDF.type, defaultType, Phase.ConceptDiscovery, null, null, null, 0.0);
        for (Assertion conceptAssertion : conceptAssertions) {
            List<Assertion> prefLabels = this.getAssertions(conceptAssertion.getSubject(), SKOS.prefLabel, null, Phase.ConceptDiscovery, null, null, Rating.Positive, 0.0);
            List<Assertion> hiddenLabels = this.getAssertions(conceptAssertion.getSubject(), SKOS.hiddenLabel, null, Phase.ConceptDiscovery, null, null, Rating.Positive, 0.0);
            ArrayList<Assertion> assertions = new ArrayList<Assertion>();
            assertions.add(prefLabels.get(0));
            assertions.addAll(hiddenLabels);
            for (Assertion assertion : assertions) {
                List list;
                boolean exists;
                String lbl = assertion.getStatement().getString();
                if (lowerCase) {
                    lbl = lbl.toLowerCase();
                }
                if (exists = (list = m.computeIfAbsent(lbl, l -> new ArrayList())).stream().anyMatch(a -> a.getStatement().equals(conceptAssertion.getStatement()))) continue;
                list.add(conceptAssertion);
            }
        }
        return m;
    }

    public static List<Assertion> filter(Collection<Assertion> assertions, Resource subject, Property predicate, RDFNode object, Phase phase, Intelligence intel, String name, Rating rating, double confidenceThreshold) {
        ArrayList<Assertion> result = new ArrayList<Assertion>();
        for (Assertion assertion : assertions) {
            if (subject != null && !assertion.getStatement().getSubject().equals(subject) || predicate != null && !assertion.getStatement().getPredicate().equals(predicate) || object != null && !assertion.getStatement().getObject().equals(object) || phase != null && assertion.getPhase() != phase || intel != null && assertion.getIntelligence() != intel || name != null && !assertion.getName().equals(name) || rating != null && assertion.getRating() != rating || confidenceThreshold > 0.0 && assertion.getConfidence() >= confidenceThreshold) continue;
            result.add(assertion);
        }
        return result;
    }

    public static Map<Rating, List<Assertion>> ratingMap(Collection<Assertion> assertions) {
        HashMap<Rating, List<Assertion>> rating2assertions = new HashMap<Rating, List<Assertion>>();
        for (Assertion assertion : assertions) {
            List l = rating2assertions.computeIfAbsent(assertion.getRating(), r -> new ArrayList());
            l.add(assertion);
        }
        return rating2assertions;
    }

    @Deprecated
    public List<Assertion> getConceptAssertionsViaTransitiveSameAs(Assertion startConceptAssertion) {
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        Stack<Assertion> stack = new Stack<Assertion>();
        stack.add(startConceptAssertion);
        HashSet<Resource> visitedConcepts = new HashSet<Resource>();
        while (!stack.isEmpty()) {
            Assertion assertion = (Assertion)stack.pop();
            if (visitedConcepts.contains(assertion.getSubject())) continue;
            visitedConcepts.add(assertion.getSubject());
            assertions.add(assertion);
            List<Assertion> outgoingSameAsList = this.getAssertions(assertion.getSubject(), OWL.sameAs, null, Phase.ConceptDiscovery, null, null, Rating.Positive, 0.0);
            for (Assertion outgoingSameAs : outgoingSameAsList) {
                List<Assertion> conceptAssertions;
                Resource target = outgoingSameAs.getStatement().getResource();
                if (visitedConcepts.contains(target) || (conceptAssertions = this.getAssertions(target, RDF.type, OWL2.NamedIndividual, Phase.ConceptDiscovery, null, null, Rating.Positive, 0.0)).isEmpty()) continue;
                stack.push(conceptAssertions.get(0));
            }
        }
        return assertions;
    }

    public int getCommitBufferSize() {
        return this.commitBuffer.size();
    }

    public boolean isBulkMode() {
        return this.bulkMode;
    }

    public void setBulkMode(boolean bulkMode) {
        this.bulkMode = bulkMode;
    }

    public boolean isLogging() {
        return this.logging;
    }

    public void setLogging(boolean logging) {
        this.logging = logging;
    }

    public abstract void commit();

    public abstract void rollback();

    public Counter getCounter() {
        return this.counter;
    }
}

