/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.hephaistos.storage.assertion;

import de.dfki.sds.hephaistos.storage.StorageItem;
import de.dfki.sds.hephaistos.storage.assertion.AssertionPool;
import de.dfki.sds.hephaistos.storage.assertion.Intelligence;
import de.dfki.sds.hephaistos.storage.assertion.Opinion;
import de.dfki.sds.hephaistos.storage.assertion.Phase;
import de.dfki.sds.hephaistos.storage.assertion.Rating;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.json.JSONArray;
import org.json.JSONObject;

public class Assertion
implements StorageItem {
    private Phase phase;
    private Statement statement;
    private Opinion artificalOpinion;
    private Opinion naturalOpinion;
    private static final Model exchange = ModelFactory.createDefaultModel();

    public Phase getPhase() {
        return this.phase;
    }

    public void setPhase(Phase phase) {
        this.phase = phase;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public Resource getSubject() {
        return this.getStatement().getSubject();
    }

    public Resource getObject() {
        return this.getStatement().getResource();
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public Opinion getArtificalOpinion() {
        return this.artificalOpinion;
    }

    public boolean hasArtificalOpinion() {
        return this.artificalOpinion != null;
    }

    public void setArtificalOpinion(Opinion artificalOpinion) {
        this.artificalOpinion = artificalOpinion;
    }

    public Opinion getNaturalOpinion() {
        return this.naturalOpinion;
    }

    public boolean hasNaturalOpinion() {
        return this.naturalOpinion != null;
    }

    public void setNaturalOpinion(Opinion naturalOpinion) {
        this.naturalOpinion = naturalOpinion;
    }

    public Opinion getOpinion(Intelligence intel) {
        if (intel == Intelligence.AI) {
            return this.artificalOpinion;
        }
        if (intel == Intelligence.NI) {
            return this.naturalOpinion;
        }
        throw new RuntimeException("");
    }

    public void setOpinion(Opinion opinion) {
        if (opinion.getIntelligence() == Intelligence.AI) {
            this.artificalOpinion = opinion;
        }
        if (opinion.getIntelligence() == Intelligence.NI) {
            this.naturalOpinion = opinion;
        }
    }

    public boolean setOpinion(Intelligence intel, String name, LocalDateTime when, Rating rating, double confidence) {
        Opinion op = this.getOpinion(intel);
        if (op == null) {
            Opinion newOp = new Opinion(intel, name, when, rating, confidence);
            this.setOpinion(newOp);
            return true;
        }
        if (!op.getName().equals(name)) {
            throw new RuntimeException(this.statement + " has already opinion " + op + " that differ in name");
        }
        boolean newInformation = op.getRating() != rating;
        op.setRating(rating);
        op.setConfidence(confidence);
        op.setWhen(when);
        return newInformation;
    }

    public Opinion getPrimaryOpinion() {
        if (this.hasNaturalOpinion()) {
            return this.naturalOpinion;
        }
        if (this.hasArtificalOpinion()) {
            return this.artificalOpinion;
        }
        throw new RuntimeException("both opinions are missing");
    }

    public Intelligence getIntelligence() {
        return this.getPrimaryOpinion().getIntelligence();
    }

    public String getName() {
        return this.getPrimaryOpinion().getName();
    }

    public LocalDateTime getWhen() {
        return this.getPrimaryOpinion().getWhen();
    }

    public Rating getRating() {
        return this.getPrimaryOpinion().getRating();
    }

    public double getConfidence() {
        return this.getPrimaryOpinion().getConfidence();
    }

    public JSONObject getStatementJson() {
        return Assertion.toJsonStatement(this.statement);
    }

    public void setStatementJson(JSONObject stmt) {
        this.statement = Assertion.parseStatement(stmt);
    }

    public String toString() {
        return "Assertion{phase=" + (Object)((Object)this.phase) + ", statement=" + this.statement + ", artificalOpinion=" + this.artificalOpinion + ", naturalOpinion=" + this.naturalOpinion + '}';
    }

    public static JSONObject toJson(List<Assertion> assertions) {
        JSONObject asObj = new JSONObject();
        Map<Rating, List<Assertion>> rating2assertions = AssertionPool.ratingMap(assertions);
        for (Rating rating : rating2assertions.keySet()) {
            asObj.put(rating.toString(), Assertion.toJsonArrayOrderByRating(rating2assertions.get((Object)rating)));
        }
        return asObj;
    }

    public static JSONArray toJsonArrayOrderByRating(List<Assertion> assertions) {
        return Assertion.toJsonArrayOrderByRating(assertions, null);
    }

    public static JSONArray toJsonArrayOrderByRating(List<Assertion> assertions, BiConsumer<Assertion, JSONObject> extra) {
        JSONArray array = Assertion.toJsonArray(assertions, extra);
        List<JSONObject> l = Assertion.getList(array, JSONObject.class);
        l.sort((a, b) -> a.getEnum(Rating.class, "rating").compareTo(b.getEnum(Rating.class, "rating")));
        return array;
    }

    public static JSONArray toJsonArrayOrderByIntel(List<Assertion> assertions) {
        return Assertion.toJsonArrayOrderByIntel(assertions, null);
    }

    public static JSONArray toJsonArrayOrderByIntel(List<Assertion> assertions, BiConsumer<Assertion, JSONObject> extra) {
        JSONArray array = Assertion.toJsonArray(assertions, extra);
        List<JSONObject> l = Assertion.getList(array, JSONObject.class);
        l.sort((a, b) -> b.getEnum(Intelligence.class, "intelligence").compareTo(a.getEnum(Intelligence.class, "intelligence")));
        return array;
    }

    public static JSONArray toJsonArrayOrderByRatingIntelConfidence(List<Assertion> assertions) {
        return Assertion.toJsonArrayOrderByRatingIntelConfidence(assertions, null);
    }

    public static void orderByRatingIntelConfidence(List<Assertion> assertions) {
        assertions.sort((a, b) -> {
            int cmpRating = a.getRating().compareTo(b.getRating());
            if (cmpRating == 0) {
                int cmpIntel = a.getIntelligence().compareTo(b.getIntelligence());
                if (cmpIntel == 0) {
                    return Double.compare(b.getConfidence(), a.getConfidence());
                }
                return cmpIntel;
            }
            return cmpRating;
        });
    }

    public static JSONArray toJsonArrayOrderByRatingIntelConfidence(List<Assertion> assertions, BiConsumer<Assertion, JSONObject> extra) {
        JSONArray array = Assertion.toJsonArray(assertions, extra);
        List<JSONObject> l = Assertion.getList(array, JSONObject.class);
        l.sort((a, b) -> {
            int cmpRating = a.getEnum(Rating.class, "rating").compareTo(b.getEnum(Rating.class, "rating"));
            if (cmpRating == 0) {
                int cmpIntel = a.getEnum(Intelligence.class, "intelligence").compareTo(b.getEnum(Intelligence.class, "intelligence"));
                if (cmpIntel == 0) {
                    return Double.compare(b.getDouble("confidence"), a.getDouble("confidence"));
                }
                return cmpIntel;
            }
            return cmpRating;
        });
        return array;
    }

    public static JSONArray toJsonArrayOrderByConfidence(List<Assertion> assertions) {
        return Assertion.toJsonArrayOrderByConfidence(assertions, null);
    }

    public static JSONArray toJsonArrayOrderByConfidence(List<Assertion> assertions, BiConsumer<Assertion, JSONObject> extra) {
        JSONArray array = Assertion.toJsonArray(assertions, extra);
        List<JSONObject> l = Assertion.getList(array, JSONObject.class);
        l.sort((a, b) -> Double.compare(b.getDouble("confidence"), a.getDouble("confidence")));
        return array;
    }

    public static JSONArray toJsonArray(List<Assertion> assertions) {
        return Assertion.toJsonArray(assertions, null);
    }

    public static JSONArray toJsonArray(List<Assertion> assertions, BiConsumer<Assertion, JSONObject> extra) {
        JSONArray array = new JSONArray();
        for (Assertion assertion : assertions) {
            JSONObject json = Assertion.toJson(assertion);
            if (extra != null) {
                extra.accept(assertion, json);
            }
            array.put(json);
        }
        return array;
    }

    public static JSONObject toJson(Assertion assertion) {
        JSONObject obj = new JSONObject();
        obj.put("statement", assertion.getStatementJson());
        obj.put("phase", (Object)assertion.getPhase());
        obj.put("intelligence", (Object)assertion.getIntelligence());
        obj.put("name", assertion.getName());
        obj.put("rating", (Object)assertion.getRating());
        obj.put("confidence", assertion.getConfidence());
        if (assertion.getStatement().getObject().isLiteral()) {
            obj.put("fixedValue", assertion.getStatement().getString());
        } else if (assertion.getStatement().getObject().isURIResource()) {
            obj.put("fixedValue", assertion.getStatement().getResource().getURI());
        }
        obj.put("when", assertion.getWhen());
        return obj;
    }

    public static Assertion fromJson(JSONObject json) {
        Assertion assertion = new Assertion();
        assertion.setPhase(json.getEnum(Phase.class, "phase"));
        assertion.setStatementJson(json.getJSONObject("statement"));
        Opinion opinion = new Opinion();
        if (json.has("confidence")) {
            opinion.setConfidence(json.getDouble("confidence"));
        }
        if (json.has("name")) {
            opinion.setName(json.getString("name"));
        }
        if (json.has("intelligence")) {
            opinion.setIntelligence(json.getEnum(Intelligence.class, "intelligence"));
        }
        if (json.has("intelligence")) {
            opinion.setRating(json.getEnum(Rating.class, "rating"));
        }
        opinion.setWhen(LocalDateTime.now());
        assertion.setOpinion(opinion);
        return assertion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Statement parseStatement(JSONObject statementJson) {
        Model model = exchange;
        synchronized (model) {
            Statement stmt = (Statement)exchange.read(new StringReader(statementJson.toString()), null, "JSON-LD").listStatements().next();
            exchange.removeAll();
            return stmt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject toJsonStatement(Statement stmt) {
        Model model = exchange;
        synchronized (model) {
            exchange.add(stmt);
            StringWriter sw = new StringWriter();
            exchange.write(sw, "JSON-LD");
            exchange.removeAll();
            return new JSONObject(sw.toString());
        }
    }

    private static <T> List<T> getList(JSONArray array, Class<T> type) {
        try {
            Field list = array.getClass().getDeclaredField("myArrayList");
            list.setAccessible(true);
            List l = (List)list.get(array);
            list.setAccessible(false);
            return l;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

