/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.hephaistos.storage;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class StorageSummaryCache {
    private Map<String, Double> doubleCache = new HashMap<String, Double>();
    private Map<String, Long> longCache = new HashMap<String, Long>();
    private Map<String, String> stringCache = new HashMap<String, String>();

    public long computeLongIfAbsent(String key, Function<String, Long> f) {
        return this.longCache.computeIfAbsent(key, f);
    }

    public double computeDoubleIfAbsent(String key, Function<String, Double> f) {
        return this.doubleCache.computeIfAbsent(key, f);
    }

    public String computeStringIfAbsent(String key, Function<String, String> f) {
        return this.stringCache.computeIfAbsent(key, f);
    }

    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(this.doubleCache.keySet());
        keys.addAll(this.longCache.keySet());
        keys.addAll(this.stringCache.keySet());
        return keys;
    }

    public boolean containsKey(String key) {
        return this.keySet().contains(key);
    }

    public void clear() {
        this.doubleCache.clear();
        this.longCache.clear();
        this.stringCache.clear();
    }

    public Object get(String key) {
        for (Map m : Arrays.asList(this.doubleCache, this.longCache, this.stringCache)) {
            if (!m.containsKey(key)) continue;
            return m.get(key);
        }
        return null;
    }
}

