/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.hephaistos.storage;

import de.dfki.sds.hephaistos.storage.StorageSummaryCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public abstract class StorageSummary {
    protected StorageSummaryCache cache;

    public StorageSummary() {
        this(new StorageSummaryCache());
    }

    public StorageSummary(StorageSummaryCache cache) {
        this.cache = cache;
    }

    public List<String> prepare() {
        return Arrays.asList(new String[0]);
    }

    public final TableModel asTableModel() {
        Vector<Object> row;
        Vector data = new Vector();
        ArrayList<String> rest = new ArrayList<String>(this.cache.keySet());
        List<String> metrics = this.prepare();
        for (String metric : metrics) {
            row = new Vector<Object>();
            row.add(metric);
            row.add(this.cache.get(metric));
            data.add(row);
            rest.remove(metric);
        }
        if (!rest.isEmpty()) {
            rest.sort((o1, o2) -> o1.compareTo((String)o2));
            for (String metric : rest) {
                if (!this.cache.containsKey(metric)) continue;
                row = new Vector();
                row.add(metric);
                row.add(this.cache.get(metric));
                data.add(row);
            }
        }
        Vector<String> columns = new Vector<String>();
        columns.add("Metric");
        columns.add("Value");
        return new DefaultTableModel(data, columns){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
    }

    public void clearCache() {
        this.cache.clear();
    }
}

