/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.hephaistos.storage;

import de.dfki.sds.hephaistos.storage.InternalStorage;
import de.dfki.sds.hephaistos.storage.InternalStorageMetaData;
import de.dfki.sds.hephaistos.storage.Utils;
import de.dfki.sds.hephaistos.storage.assertion.AssertionPool;
import de.dfki.sds.hephaistos.storage.assertion.AssertionPoolSqlite;
import de.dfki.sds.hephaistos.storage.file.FileInfoStorage;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;

public class StorageManager {
    public static final String KG_RES_SEG = "knowledgeResource";
    transient File folder;
    private transient Connection connection;
    private Map<String, InternalStorageMetaData> id2metadata;
    public static final String DEFAULT_FILENAME = "data.sqlite";
    private String filename = "data.sqlite";

    private StorageManager() {
    }

    public StorageManager(File folder) {
        this.folder = folder;
        this.folder.mkdirs();
        this.id2metadata = new HashMap<String, InternalStorageMetaData>();
    }

    public void open() {
        try {
            this.connection = DriverManager.getConnection(this.getSqliteConnectionString());
        }
        catch (SQLException ex) {
            Utils.saveException(this.folder, ex);
            throw new RuntimeException(ex);
        }
    }

    public void close() {
        try {
            this.connection.close();
        }
        catch (SQLException ex) {
            Utils.saveException(this.folder, ex);
            throw new RuntimeException(ex);
        }
    }

    public FileInfoStorage getFileInfoStorage() {
        return this.getFileInfoStorage(this.generateId());
    }

    public FileInfoStorage getFileInfoStorage(String id) {
        return this.getStorage(id, FileInfoStorage.class);
    }

    public AssertionPool getAssertionPool() {
        return this.getAssertionPool(this.generateId());
    }

    public AssertionPool getAssertionPool(String id) {
        return this.getStorage(id, AssertionPool.class);
    }

    public <T extends InternalStorage> T getStorage(String id, Class<T> type) {
        InternalStorageMetaData metadata = this.id2metadata.computeIfAbsent(id, ident -> new InternalStorageMetaData((String)ident, type.getName()));
        if (type == FileInfoStorage.class) {
            return (T)new FileInfoStorage(metadata, this.connection, new File(this.folder, "cache"));
        }
        if (type == AssertionPool.class) {
            return (T)new AssertionPoolSqlite(metadata, this.connection, this.folder);
        }
        this.id2metadata.remove(id);
        throw new RuntimeException("No storage implementation found for " + type);
    }

    public <T extends InternalStorage> T getStorage(Class<T> type) {
        return this.getStorage(this.generateId(), type);
    }

    public InternalStorage getStorage(String id) {
        Class<?> clazz;
        String className = this.id2metadata.get(id).getClassName();
        try {
            clazz = StorageManager.class.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            Utils.saveException(this.folder, ex);
            throw new RuntimeException(ex);
        }
        return this.getStorage(id, clazz);
    }

    public List<InternalStorage> getStorages(List<String> ids) {
        ArrayList<InternalStorage> storages = new ArrayList<InternalStorage>();
        for (String id : ids) {
            storages.add(this.getStorage(id));
        }
        return storages;
    }

    public void removeStorage(String id) {
        if (!this.id2metadata.containsKey(id)) {
            throw new RuntimeException("Internal storage does not exist with id " + id);
        }
        InternalStorage s = this.getStorage(id);
        try {
            s.remove();
        }
        catch (Exception exception) {
            // empty catch block
        }
        s.close();
    }

    public boolean containsStorage(String id) {
        try {
            ResultSet tables = this.connection.getMetaData().getTables(null, null, null, new String[]{"TABLE"});
            while (tables.next()) {
                if (!tables.getString(3).startsWith(id + "_")) continue;
                return true;
            }
            return false;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public File getSqliteFile() {
        return new File(this.folder, this.filename);
    }

    private String getSqliteConnectionString() {
        if (this.folder == null) {
            throw new RuntimeException("folder is null");
        }
        return "jdbc:sqlite:" + this.getSqliteFile().getAbsolutePath();
    }

    private String getTDB2Location() {
        File tdb2 = new File(this.folder, "tdb2");
        tdb2.mkdirs();
        return tdb2.getAbsolutePath();
    }

    private String generateId() {
        return RandomStringUtils.randomAlphabetic(6);
    }
}

