/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.hephaistos.storage;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.function.Function;

public class ResultSetIterator<T>
implements Iterator<T> {
    private boolean didNext = false;
    private boolean hasNext = false;
    private PreparedStatement stmt;
    private ResultSet rs;
    private Function<ResultSet, T> rs2t;

    public ResultSetIterator(PreparedStatement stmt, Function<ResultSet, T> rs2t) {
        this.stmt = stmt;
        this.rs2t = rs2t;
        try {
            this.rs = stmt.executeQuery();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void checkHasNext(boolean setDidNextToTrue) {
        if (!this.didNext) {
            try {
                this.hasNext = this.rs.next();
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            if (setDidNextToTrue) {
                this.didNext = true;
            }
        }
        if (!setDidNextToTrue) {
            this.didNext = false;
        }
    }

    @Override
    public boolean hasNext() {
        this.checkHasNext(true);
        if (!this.hasNext) {
            this.close();
        }
        return this.hasNext;
    }

    @Override
    public T next() {
        this.checkHasNext(false);
        try {
            return this.rs2t.apply(this.rs);
        }
        catch (Exception e2) {
            this.close();
            throw e2;
        }
    }

    public PreparedStatement getPreparedStatement() {
        return this.stmt;
    }

    public void close() {
        try {
            this.stmt.close();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }
}

