/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.hephaistos.storage;

import de.dfki.sds.hephaistos.storage.BranchLeafStorage;
import de.dfki.sds.hephaistos.storage.InternalStorageMetaData;
import de.dfki.sds.hephaistos.storage.ResultSetIterator;
import de.dfki.sds.hephaistos.storage.SQLiteUtility;
import de.dfki.sds.hephaistos.storage.StorageItem;
import de.dfki.sds.hephaistos.storage.StorageSummary;
import de.dfki.sds.hephaistos.storage.TypedName;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import org.apache.commons.io.IOUtils;

public abstract class BranchLeafStorageSqlite<Branch extends StorageItem, Leaf extends StorageItem, S extends StorageSummary>
extends BranchLeafStorage<Branch, Leaf, S, ResultSet> {
    protected final String COL_ID = "id";
    protected final String COL_PARENT = "parent";
    protected final String COL_SORT = "sort";
    protected final String COL_TYPE = "type";
    protected List<TypedName> nodeSchema = Arrays.asList(new TypedName("id", Integer.class), new TypedName("parent", Integer.class), new TypedName("sort", Integer.class), new TypedName("type", Integer.class));
    protected final int ROOT_ID = 1;
    protected final int BRANCH_TYPE = 0;
    protected final int LEAF_TYPE = 1;
    private String tablename;
    private Connection connection;

    public BranchLeafStorageSqlite(InternalStorageMetaData metaData, Connection connection) {
        super(metaData);
        this.tablename = metaData.getId();
        this.connection = connection;
        this.init();
    }

    protected abstract List<TypedName> getBranchSchema();

    protected abstract List<TypedName> getLeafSchema();

    protected abstract Object[] getBranchInsertParams(Branch var1);

    protected abstract Object[] getLeafInsertParams(Leaf var1);

    protected abstract Class<Branch> getBranchClass();

    protected abstract Class<Leaf> getLeafClass();

    protected abstract Branch getBranchFromRow(Row var1);

    protected abstract Leaf getLeafFromRow(Row var1);

    protected abstract MetaData getBranchMetaData(Branch var1);

    protected abstract MetaData getLeafMetaData(Leaf var1);

    protected abstract void setBranchMetaData(Branch var1, MetaData var2);

    protected abstract void setLeafMetaData(Leaf var1, MetaData var2);

    protected void insertAdditionally(Leaf leaf) {
    }

    protected void retrieveAdditionally(Leaf leaf) {
    }

    protected void removeAdditionally(Leaf leaf) {
    }

    private void init() {
        SQLiteUtility.run(this.connection, c -> {
            String createTableQuery = this.getCreateTableQuery();
            c.prepareStatement(createTableQuery).execute();
            this.insertRoot(c);
        });
    }

    private List<TypedName> getAllTypeNames() {
        ArrayList<TypedName> allTypedNames = new ArrayList<TypedName>();
        allTypedNames.addAll(this.nodeSchema);
        allTypedNames.addAll(this.getBranchLeafTypeNames());
        return allTypedNames;
    }

    private List<TypedName> getBranchLeafTypeNames() {
        ArrayList<TypedName> allTypedNames = new ArrayList<TypedName>();
        for (TypedName tn : this.getBranchSchema()) {
            allTypedNames.add(tn.withPrefix("branch_"));
        }
        for (TypedName tn : this.getLeafSchema()) {
            allTypedNames.add(tn.withPrefix("leaf_"));
        }
        return allTypedNames;
    }

    private String getCreateTableQuery() {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE IF NOT EXISTS \"" + this.tablename + "\" (");
        String notNullPrimary = "NOT NULL PRIMARY KEY AUTOINCREMENT";
        boolean first = true;
        for (TypedName typedName : this.getAllTypeNames()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("\"" + typedName.getName() + "\"\t" + this.getSqliteType(typedName.getType()));
            if (first) {
                sb.append(" " + notNullPrimary);
                first = false;
            }
            sb.append("\n");
        }
        sb.append(");");
        return sb.toString();
    }

    private String getClearQuery() {
        return "DELETE FROM \"" + this.tablename + "\" WHERE id != 1;";
    }

    private String getRootQuery() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT *\n");
        sb.append("FROM \"" + this.tablename + "\"\n");
        sb.append("WHERE id = 1\n");
        sb.append("LIMIT 1;");
        return sb.toString();
    }

    private String getSelectQuery(int id) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT *\n");
        sb.append("FROM \"" + this.tablename + "\"\n");
        sb.append("WHERE id = " + id + "\n");
        sb.append("LIMIT 1;");
        return sb.toString();
    }

    private String getSelectIdQuery() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT id\n");
        sb.append("FROM \"" + this.tablename + "\"");
        return sb.toString();
    }

    private String getInsertIntoValuesQuestionmarks(boolean orIgnore) {
        return "INSERT " + (orIgnore ? "OR IGNORE " : "") + "INTO \"" + this.tablename + "\" VALUES (" + this.getQuestionmarks(this.getAllTypeNames().size()) + ");";
    }

    private void insertRoot(Connection c) throws SQLException {
        String insertRootQuery = this.getInsertIntoValuesQuestionmarks(true);
        PreparedStatement ps = c.prepareStatement(insertRootQuery);
        this.setParametersNull(ps);
        ps.setInt(1, 1);
        ps.setInt(2, 0);
        ps.setInt(3, 0);
        ps.setInt(4, 0);
        ps.execute();
    }

    private String getQuery(String path) {
        try {
            String query = IOUtils.toString(BranchLeafStorageSqlite.class.getResourceAsStream(path), StandardCharsets.UTF_8);
            query = query.replaceAll("\\$\\{tablename\\}", this.tablename);
            return query;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private PreparedStatement getChildrenPreparedStatement(Branch node, int type) {
        return SQLiteUtility.prepare(this.connection, this.getQuery("/de/dfki/sds/hephaistos/storage/Children.sql"), ps -> {
            ps.setInt(1, this.getBranchMetaDataInner(node).getId());
            ps.setInt(2, type);
        });
    }

    private MetaData getMetaData(StorageItem node) {
        MetaData md;
        Class<?> subclass = node.getClass();
        if (this.getBranchClass().isAssignableFrom(subclass)) {
            md = this.getBranchMetaDataInner(node);
        } else if (this.getLeafClass().isAssignableFrom(subclass)) {
            md = this.getLeafMetaDataInner(node);
        } else {
            throw new RuntimeException(node.getClass() + " is neither " + this.getBranchClass() + " nor " + this.getLeafClass());
        }
        return md;
    }

    private MetaData getBranchMetaDataInner(Branch branch) {
        MetaData md = this.getBranchMetaData(branch);
        if (!md.isTypeSet()) {
            md.setType(0);
        }
        return md;
    }

    private MetaData getLeafMetaDataInner(Leaf leaf) {
        MetaData md = this.getLeafMetaData(leaf);
        if (!md.isTypeSet()) {
            md.setType(1);
        }
        return md;
    }

    private PreparedStatement getParentsPreparedStatement(StorageItem node) {
        MetaData md = this.getMetaData(node);
        return SQLiteUtility.prepare(this.connection, this.getQuery("/de/dfki/sds/hephaistos/storage/Parents.sql"), ps -> ps.setInt(1, md.getId()));
    }

    private PreparedStatement getParentPreparedStatement(StorageItem node) {
        MetaData md = this.getMetaData(node);
        return SQLiteUtility.prepare(this.connection, this.getQuery("/de/dfki/sds/hephaistos/storage/Parent.sql"), ps -> ps.setInt(1, md.getId()));
    }

    private PreparedStatement getTreePreparedStatement(Branch node) {
        return SQLiteUtility.prepare(this.connection, this.getQuery("/de/dfki/sds/hephaistos/storage/SelectTree.sql"), ps -> ps.setInt(1, this.getBranchMetaDataInner(node).getId()));
    }

    private Branch getBranchFromResultSet(ResultSet rs) {
        Branch b = this.getBranchFromRow(new Row(rs, 0));
        this.setBranchMetaData(b, new MetaData(rs));
        return b;
    }

    private Leaf getLeafFromResultSet(ResultSet rs) {
        Leaf l = this.getLeafFromRow(new Row(rs, 1));
        this.setLeafMetaData(l, new MetaData(rs));
        this.retrieveAdditionally(l);
        return l;
    }

    private String getQuestionmarks(int n) {
        StringJoiner sj = new StringJoiner(",");
        for (int i = 0; i < n; ++i) {
            sj.add("?");
        }
        return sj.toString();
    }

    private String getSqliteType(Class type) {
        if (type == Integer.class || type == Long.class || type == Boolean.class) {
            return "INTEGER";
        }
        if (type == String.class || type == Character.class) {
            return "TEXT";
        }
        if (type == Float.class || type == Double.class) {
            return "REAL";
        }
        throw new RuntimeException(type + " not supported");
    }

    private void setParametersNull(PreparedStatement ps) throws SQLException {
        for (int i = 0; i < ps.getParameterMetaData().getParameterCount(); ++i) {
            if (ps.getParameterMetaData().isNullable(i + 1) != 1) continue;
            ps.setNull(i + 1, 1111);
        }
    }

    private void insert(StorageItem node, Branch parent, boolean nodeIsBranch, String firstOrLast) {
        int n = this.getBranchLeafTypeNames().size();
        int parentId = this.getBranchMetaDataInner(parent).getId();
        int branchSchemaLength = this.getBranchSchema().size();
        String query = this.getQuery("/de/dfki/sds/hephaistos/storage/Insert" + firstOrLast + ".sql").replaceAll("\\$\\{params\\}", this.getQuestionmarks(n));
        SQLiteUtility.run(this.connection, c -> {
            PreparedStatement stmt;
            block16: {
                stmt = c.prepareStatement(query, 1);
                this.setParametersNull(stmt);
                stmt.setInt(1, parentId);
                stmt.setInt(2, parentId);
                stmt.setInt(3, parentId);
                stmt.setInt(4, nodeIsBranch ? 0 : 1);
                Object[] values = nodeIsBranch ? this.getBranchInsertParams(node) : this.getLeafInsertParams(node);
                for (int i = 0; i < values.length; ++i) {
                    stmt.setObject(5 + (nodeIsBranch ? 0 : branchSchemaLength) + i, values[i]);
                }
                stmt.execute();
                try (ResultSet generatedKeys = stmt.getGeneratedKeys();){
                    MetaData md = new MetaData();
                    if (generatedKeys.next()) {
                        md.setId(generatedKeys.getInt(1));
                        md.setParent(parentId);
                        if (nodeIsBranch) {
                            this.setBranchMetaData(node, md);
                        } else {
                            this.setLeafMetaData(node, md);
                        }
                        break block16;
                    }
                    throw new SQLException("No ID generated");
                }
            }
            stmt.close();
        });
        if (!nodeIsBranch) {
            this.insertAdditionally(node);
        }
    }

    @Override
    public void insertBranchAsFirstChild(Branch node, Branch parent) {
        this.insert((StorageItem)node, parent, true, "First");
    }

    @Override
    public void insertBranchAsLastChild(Branch node, Branch parent) {
        this.insert((StorageItem)node, parent, true, "Last");
    }

    @Override
    public void insertLeafAsFirstChild(Leaf node, Branch parent) {
        this.insert((StorageItem)node, parent, false, "First");
    }

    @Override
    public void insertLeafAsLastChild(Leaf node, Branch parent) {
        this.insert((StorageItem)node, parent, false, "Last");
    }

    @Override
    public void insertBulk(Collection<? extends StorageItem> tree) {
        int n = this.getBranchLeafTypeNames().size();
        int branchSchemaLength = this.getBranchSchema().size();
        String query = this.getQuery("/de/dfki/sds/hephaistos/storage/Insert.sql").replaceAll("\\$\\{params\\}", this.getQuestionmarks(n));
        SQLiteUtility.run(this.connection, c -> {
            c.setAutoCommit(false);
            PreparedStatement stmt = c.prepareStatement(query);
            for (StorageItem node : tree) {
                int offset;
                Object[] values;
                MetaData md = this.getMetaData(node);
                if (md.type == 0) {
                    StorageItem b = node;
                    values = this.getBranchInsertParams(b);
                    offset = 0;
                } else if (md.type == 1) {
                    StorageItem l = node;
                    this.insertAdditionally(l);
                    values = this.getLeafInsertParams(l);
                    offset = branchSchemaLength;
                } else {
                    throw new RuntimeException(md.type + " type not allowed");
                }
                this.setParametersNull(stmt);
                stmt.setInt(1, md.id);
                stmt.setInt(2, md.parent);
                stmt.setInt(3, md.sort);
                stmt.setInt(4, md.type);
                for (int i = 0; i < values.length; ++i) {
                    stmt.setObject(this.nodeSchema.size() + 1 + offset + i, values[i]);
                }
                stmt.addBatch();
            }
            stmt.executeBatch();
            c.commit();
        });
    }

    @Override
    public void updateBranch(Branch node) {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public void updateLeaf(Leaf node) {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public void removeSingleBranch(Branch node) {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public void removeSingleLeaf(Leaf node) {
        SQLiteUtility.executePrepared(this.connection, this.getQuery("/de/dfki/sds/hephaistos/storage/DeleteSingle.sql"), ps -> ps.setInt(1, this.getLeafMetaDataInner(node).getId()));
        this.removeAdditionally(node);
    }

    @Override
    public void removeSubtree(Branch node) {
        SQLiteUtility.executePrepared(this.connection, this.getQuery("/de/dfki/sds/hephaistos/storage/DeleteMulti.sql"), ps -> ps.setInt(1, this.getBranchMetaDataInner(node).getId()));
    }

    @Override
    public Branch getRoot() {
        return (Branch)SQLiteUtility.supply(this.connection, c -> {
            PreparedStatement ps = c.prepareStatement(this.getRootQuery());
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                ps.close();
                throw new SQLException("root not found");
            }
            Branch root2 = this.getBranchFromResultSet(rs);
            ps.close();
            return root2;
        });
    }

    @Override
    public StorageItem get(int id) {
        return SQLiteUtility.supply(this.connection, c -> {
            PreparedStatement ps = c.prepareStatement(this.getSelectQuery(id));
            ResultSet rs = ps.executeQuery();
            StorageItem item = null;
            if (rs.next()) {
                if (rs.getInt("type") == 0) {
                    item = (StorageItem)this.getBranchFromResultSet(rs);
                } else if (rs.getInt("type") == 1) {
                    item = (StorageItem)this.getLeafFromResultSet(rs);
                }
            } else {
                ps.close();
                throw new SQLException("item not found with id " + id);
            }
            ps.close();
            return item;
        });
    }

    @Override
    public Iterable<Branch> getBranchChildrenIter(Branch node) {
        return () -> {
            PreparedStatement ps = this.getChildrenPreparedStatement(node, 0);
            return new ResultSetIterator<StorageItem>(ps, rs -> this.getBranchFromResultSet((ResultSet)rs));
        };
    }

    @Override
    public Iterable<Leaf> getLeafChildrenIter(Branch node) {
        return () -> {
            PreparedStatement ps = this.getChildrenPreparedStatement(node, 1);
            return new ResultSetIterator<StorageItem>(ps, rs -> this.getLeafFromResultSet((ResultSet)rs));
        };
    }

    @Override
    public Optional<Branch> getParentOf(StorageItem branchOrLeaf) {
        PreparedStatement ps = this.getParentPreparedStatement(branchOrLeaf);
        try {
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                return Optional.empty();
            }
            Branch b = this.getBranchFromResultSet(rs);
            ps.close();
            return Optional.of(b);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Iterable<Branch> getParentsIter(StorageItem branchOrLeaf) {
        return () -> {
            PreparedStatement ps = this.getParentsPreparedStatement(branchOrLeaf);
            return new ResultSetIterator<StorageItem>(ps, rs -> this.getBranchFromResultSet((ResultSet)rs));
        };
    }

    @Override
    public Iterable<StorageItem> getTreeIter(Branch node) {
        return () -> {
            PreparedStatement ps = this.getTreePreparedStatement(node);
            return new ResultSetIterator<StorageItem>(ps, rs -> {
                try {
                    int type = rs.getInt("type");
                    if (type == 0) {
                        Branch o = this.getBranchFromResultSet((ResultSet)rs);
                        return o;
                    }
                    if (type == 1) {
                        Leaf o = this.getLeafFromResultSet((ResultSet)rs);
                        this.retrieveAdditionally(o);
                        return o;
                    }
                    throw new SQLException("Illegal type " + type);
                }
                catch (SQLException ex) {
                    throw new RuntimeException(ex);
                }
            });
        };
    }

    @Override
    public void clear() {
        SQLiteUtility.execute(this.connection, this.getClearQuery());
    }

    @Override
    public void remove() {
        SQLiteUtility.execute(this.connection, this.getQuery("/de/dfki/sds/hephaistos/storage/Drop.sql"));
    }

    @Override
    public long size() {
        String query = this.getQuery("/de/dfki/sds/hephaistos/storage/Count.sql");
        return SQLiteUtility.supply(this.connection, c -> {
            PreparedStatement stmt = c.prepareStatement(query);
            ResultSet rs = stmt.executeQuery();
            long size = rs.getLong(1);
            stmt.close();
            return size;
        });
    }

    public long getCount(int type) {
        String query = this.getQuery("/de/dfki/sds/hephaistos/storage/CountType.sql");
        return SQLiteUtility.supply(this.connection, c -> {
            PreparedStatement stmt = c.prepareStatement(query);
            stmt.setInt(1, type);
            ResultSet rs = stmt.executeQuery();
            long size = rs.getLong(1);
            stmt.close();
            return size;
        });
    }

    @Override
    public long getBranchCount() {
        return this.getCount(0);
    }

    @Override
    public long getLeafCount() {
        return this.getCount(1);
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isRoot(Branch node) {
        return this.getBranchMetaData(node).id == 1;
    }

    @Override
    public boolean isBranch(StorageItem node) {
        return this.getMetaData(node).type == 0;
    }

    @Override
    public boolean isLeaf(StorageItem node) {
        return this.getMetaData(node).type == 1;
    }

    protected class Row {
        private ResultSet rs;
        private int offset;

        public Row(ResultSet rs, int type) {
            this.rs = rs;
            this.offset = type == 1 ? BranchLeafStorageSqlite.this.getBranchSchema().size() : 0;
        }

        public int getInt(int index) {
            try {
                return this.rs.getInt(BranchLeafStorageSqlite.this.nodeSchema.size() + this.offset + index);
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }

        public long getLong(int index) {
            try {
                return this.rs.getLong(BranchLeafStorageSqlite.this.nodeSchema.size() + this.offset + index);
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }

        public String getString(int index) {
            try {
                return this.rs.getString(BranchLeafStorageSqlite.this.nodeSchema.size() + this.offset + index);
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }

        public double getDouble(int index) {
            try {
                return this.rs.getDouble(BranchLeafStorageSqlite.this.nodeSchema.size() + this.offset + index);
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }

        public float getFloat(int index) {
            try {
                return this.rs.getFloat(BranchLeafStorageSqlite.this.nodeSchema.size() + this.offset + index);
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }

        public boolean getBoolean(int index) {
            try {
                return this.rs.getBoolean(BranchLeafStorageSqlite.this.nodeSchema.size() + this.offset + index);
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    protected class MetaData {
        private int id;
        private int parent;
        private int sort;
        private int type;
        private boolean typeSet;

        public MetaData() {
        }

        public MetaData(int id, int parent, int sort) {
            this.id = id;
            this.parent = parent;
            this.sort = sort;
        }

        public MetaData(int id, int parent, int sort, int type) {
            this.id = id;
            this.parent = parent;
            this.sort = sort;
            this.type = type;
            this.typeSet = true;
        }

        public MetaData(ResultSet rs) {
            try {
                this.id = rs.getInt("id");
                this.parent = rs.getInt("parent");
                this.sort = rs.getInt("sort");
                this.type = rs.getInt("type");
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public int getParent() {
            return this.parent;
        }

        public void setParent(int parent) {
            this.parent = parent;
        }

        public int getSort() {
            return this.sort;
        }

        public void setSort(int sort) {
            this.sort = sort;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
            this.typeSet = true;
        }

        private boolean isTypeSet() {
            return this.typeSet;
        }

        public String toString() {
            return "MetaData{id=" + this.id + ", parent=" + this.parent + ", sort=" + this.sort + '}';
        }
    }
}

