/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.hephaistos.storage;

import de.dfki.sds.hephaistos.storage.InternalStorage;
import de.dfki.sds.hephaistos.storage.InternalStorageMetaData;
import de.dfki.sds.hephaistos.storage.StorageItem;
import de.dfki.sds.hephaistos.storage.StorageSummary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public abstract class BranchLeafStorage<Branch extends StorageItem, Leaf extends StorageItem, S extends StorageSummary, RS>
extends InternalStorage<StorageItem, S, RS> {
    public BranchLeafStorage(InternalStorageMetaData metaData) {
        super(metaData);
    }

    public abstract void insertBranchAsFirstChild(Branch var1, Branch var2);

    public abstract void insertBranchAsLastChild(Branch var1, Branch var2);

    public abstract void insertLeafAsFirstChild(Leaf var1, Branch var2);

    public abstract void insertLeafAsLastChild(Leaf var1, Branch var2);

    public abstract void insertBulk(Collection<? extends StorageItem> var1);

    public abstract void removeSingleBranch(Branch var1);

    public abstract void removeSingleLeaf(Leaf var1);

    public abstract void updateBranch(Branch var1);

    public abstract void updateLeaf(Leaf var1);

    public abstract void removeSubtree(Branch var1);

    public abstract Branch getRoot();

    public abstract Iterable<Branch> getBranchChildrenIter(Branch var1);

    public abstract Iterable<Leaf> getLeafChildrenIter(Branch var1);

    public abstract Optional<Branch> getParentOf(StorageItem var1);

    public abstract Iterable<Branch> getParentsIter(StorageItem var1);

    public abstract Iterable<StorageItem> getTreeIter(Branch var1);

    public abstract boolean isRoot(Branch var1);

    public abstract boolean isBranch(StorageItem var1);

    public abstract boolean isLeaf(StorageItem var1);

    public abstract StorageItem get(int var1);

    public abstract long getBranchCount();

    public abstract long getLeafCount();

    public List<Branch> getParents(StorageItem node) {
        ArrayList result = new ArrayList();
        this.getParentsIter(node).forEach(result::add);
        return result;
    }

    public List<Branch> getParentsInverted(StorageItem node) {
        List<Branch> l = this.getParents(node);
        Collections.reverse(l);
        return l;
    }

    public List<Branch> getParentsInvertedRootless(StorageItem node) {
        List<Branch> l = this.getParents(node);
        Collections.reverse(l);
        return l.subList(1, l.size());
    }

    public List<Branch> getBranchChildren(Branch node) {
        ArrayList result = new ArrayList();
        this.getBranchChildrenIter(node).forEach(result::add);
        return result;
    }

    public List<Leaf> getLeafChildren(Branch node) {
        ArrayList result = new ArrayList();
        this.getLeafChildrenIter(node).forEach(result::add);
        return result;
    }

    public List<StorageItem> getTree(Branch node) {
        ArrayList<StorageItem> result = new ArrayList<StorageItem>();
        this.getTreeIter(node).forEach(result::add);
        return result;
    }
}

