/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sds.hephaistos;

import de.dfki.sds.hephaistos.Setting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class Preference
extends ArrayList<Setting> {
    public Preference() {
    }

    public Preference(Collection<? extends Setting> c) {
        super(c);
    }

    public Preference(Setting ... settings) {
        super(Arrays.asList(settings));
    }

    public Preference(Preference pref) {
        for (Setting setting : pref) {
            this.add(new Setting(setting));
        }
    }

    public void applyValuesFrom(Preference pref) {
        for (Setting other : pref) {
            Setting my = this.get(other.getName());
            if (my == null) continue;
            my.setValue(other.getValue());
            my.setArray(other.getArray());
            my.setChoice(other.getChoice());
        }
    }

    public boolean has(String name) {
        return this.get(name) != null;
    }

    public Setting get(String name) {
        for (Setting setting : this) {
            if (!setting.getName().equals(name)) continue;
            return setting;
        }
        return null;
    }

    public boolean getValueAsBoolean(String name) {
        return this.getValueAsBoolean(name, false);
    }

    public boolean getValueAsBoolean(String name, boolean def) {
        if (!this.has(name)) {
            return def;
        }
        return (Boolean)this.get(name).getValue();
    }

    public String getValueAsString(String name) {
        return this.getValueAsString(name, null);
    }

    public String getValueAsString(String name, String def) {
        if (!this.has(name)) {
            return def;
        }
        return (String)this.get(name).getValue();
    }

    public int getValueAsInt(String name) {
        return this.getValueAsInt(name, 0);
    }

    public int getValueAsInt(String name, int def) {
        if (!this.has(name)) {
            return def;
        }
        Object value = this.get(name).getValue();
        if (value instanceof Double) {
            return (int)Math.round((Double)value);
        }
        return (Integer)this.get(name).getValue();
    }

    public Preference setValue(String name, int value) {
        if (!this.has(name)) {
            this.add(new Setting(name, value));
            return this;
        }
        this.get(name).setValue(value);
        return this;
    }

    public Preference setValue(String name, String value) {
        if (!this.has(name)) {
            this.add(new Setting(name, value));
            return this;
        }
        this.get(name).setValue(value);
        return this;
    }

    public Preference setValue(String name, boolean value) {
        if (!this.has(name)) {
            this.add(new Setting(name, value));
            return this;
        }
        this.get(name).setValue(value);
        return this;
    }
}

