/*
 * Decompiled with CFR 0.152.
 */
package com.r6lab.sparkjava.jwt.controller;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.r6lab.sparkjava.jwt.AuthFilter;
import com.r6lab.sparkjava.jwt.TokenService;
import com.r6lab.sparkjava.jwt.controller.AbstractTokenController;
import com.r6lab.sparkjava.jwt.user.User;
import com.r6lab.sparkjava.jwt.user.UserService;
import de.dfki.sds.kecs.util.KecsUtils;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.stream.Collectors;
import org.eclipse.jetty.http.MimeTypes;
import org.json.JSONObject;
import org.mindrot.jbcrypt.BCrypt;
import spark.Request;
import spark.Response;
import spark.Spark;

public class AuthController
extends AbstractTokenController {
    private static final String ROLE_PROPERTY = "role";
    private static final String TOKEN_PREFIX = "Bearer";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String USER_NAME_PROPERTY = "userName";
    private static final String FIRST_NAME_PROPERTY = "firstName";
    private static final String LAST_NAME_PROPERTY = "lastName";
    private static final String PASSWORD_PROPERTY = "password";
    private static final String SECRET_PROPERTY = "secret";
    private static final String AUTH_ENDPOINT_PREFIX = "/auth";
    public static final String BCRYPT_SALT = "$2a$10$MOu3S18JDjMntZRv/hum0.";
    private final Gson gson;
    private final UserService userService;
    private final TokenService tokenService;
    private File resultFolder;

    public AuthController(Gson gson, UserService userService, TokenService tokenService, File resultFolder) {
        super(tokenService);
        this.gson = gson;
        this.userService = userService;
        this.tokenService = tokenService;
        this.resultFolder = resultFolder;
    }

    public void init() {
        Spark.before(new AuthFilter(AUTH_ENDPOINT_PREFIX, this.tokenService));
        Spark.post("/auth/login", (request, response) -> this.login(request, response));
        Spark.post("/auth/logout", (request, response) -> this.logout(request));
    }

    private String logout(Request request) {
        String token = AuthController.getToken(request);
        this.tokenService.revokeToken(token);
        return "";
    }

    private String login(Request request, Response response) throws IOException {
        String json = request.raw().getReader().lines().collect(Collectors.joining());
        JsonObject jsonRequest = this.gson.fromJson(json, JsonObject.class);
        if (this.validatePost(jsonRequest)) {
            try {
                JSONObject interaction = new JSONObject();
                interaction.put("uri", "/auth/login");
                interaction.put("when", LocalDateTime.now().toString());
                interaction.put("username", jsonRequest.get(USER_NAME_PROPERTY).getAsString());
                KecsUtils.saveInteraction(interaction, this.resultFolder);
                String encryptedPassword = BCrypt.hashpw(jsonRequest.get(PASSWORD_PROPERTY).getAsString(), BCRYPT_SALT);
                User user = this.userService.get(jsonRequest.get(USER_NAME_PROPERTY).getAsString());
                if (!user.getPassword().equals(encryptedPassword)) {
                    response.status(401);
                    response.type(MimeTypes.Type.APPLICATION_JSON.asString());
                    JSONObject result = new JSONObject();
                    result.put("msg", "login failed");
                    return result.toString(2);
                }
                String token = this.tokenService.newToken(user);
                response.header(AUTHORIZATION_HEADER, "Bearer " + token);
                response.cookie("/", "token", token, 604800, false, true);
            }
            catch (Exception e2) {
                response.status(401);
                response.type(MimeTypes.Type.APPLICATION_JSON.asString());
                JSONObject result = new JSONObject();
                result.put("msg", e2.getMessage());
                return result.toString(2);
            }
        }
        return "";
    }

    private boolean validatePost(JsonObject jsonRequest) {
        return jsonRequest != null && jsonRequest.has(USER_NAME_PROPERTY) && jsonRequest.has(PASSWORD_PROPERTY);
    }
}

