/*
 * Decompiled with CFR 0.152.
 */
package com.r6lab.sparkjava.jwt;

import com.r6lab.sparkjava.jwt.BlacklistedTokenRepository;
import com.r6lab.sparkjava.jwt.user.User;
import com.r6lab.sparkjava.jwt.user.UserPrincipal;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.impl.DefaultClaims;
import java.util.Date;

public final class TokenService {
    public static final long EXPIRATION_TIME = 604800000L;
    private static final String ROLES = "roles";
    private final String jwtSecretKey;
    private final BlacklistedTokenRepository blacklistedTokenRepository = new BlacklistedTokenRepository();

    public TokenService(String jwtSecretKey) {
        this.jwtSecretKey = jwtSecretKey;
    }

    public final void removeExpired() {
        this.blacklistedTokenRepository.removeExpired();
    }

    public final String newToken(User user) {
        DefaultClaims claims = new DefaultClaims();
        claims.setSubject(user.getUserName());
        return Jwts.builder().setClaims(claims).setExpiration(new Date(System.currentTimeMillis() + 604800000L)).signWith(SignatureAlgorithm.HS512, this.jwtSecretKey).compact();
    }

    public final void revokeToken(String token) {
        if (token == null) {
            return;
        }
        Date expirationDate = ((Claims)Jwts.parser().setSigningKey(this.jwtSecretKey).parseClaimsJws(token).getBody()).getExpiration();
        this.blacklistedTokenRepository.addToken(token, expirationDate.getTime());
    }

    public final UserPrincipal getUserPrincipal(String token) {
        Claims claims = (Claims)Jwts.parser().setSigningKey(this.jwtSecretKey).parseClaimsJws(token).getBody();
        return UserPrincipal.of(claims.getSubject());
    }

    public final boolean isTokenBlacklisted(String token) {
        return this.blacklistedTokenRepository.isTokenBlacklisted(token);
    }

    public final boolean validateToken(String token) {
        if (token == null) {
            return false;
        }
        if (!this.isTokenBlacklisted(token)) {
            try {
                this.getUserPrincipal(token);
                return true;
            }
            catch (Exception e2) {
                return false;
            }
        }
        return false;
    }
}

