/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.util;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.MemcachedClientIF;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.internal.ImmediateFuture;

public class CacheLoader
extends SpyObject {
    private final ExecutorService executorService;
    private final StorageListener storageListener;
    private final MemcachedClientIF client;
    private final int expiration;

    public CacheLoader(MemcachedClientIF c) {
        this(c, null, null, 0);
    }

    public CacheLoader(MemcachedClientIF c, ExecutorService es, StorageListener sl, int exp) {
        this.client = c;
        this.executorService = es;
        this.storageListener = sl;
        this.expiration = exp;
    }

    public <T> Future<?> loadData(Iterator<Map.Entry<String, T>> i) {
        Future<Boolean> mostRecent = null;
        while (i.hasNext()) {
            Map.Entry<String, T> e = i.next();
            mostRecent = this.push(e.getKey(), e.getValue());
            this.watch(e.getKey(), mostRecent);
        }
        return mostRecent == null ? new ImmediateFuture(true) : mostRecent;
    }

    public <T> Future<?> loadData(Map<String, T> map) {
        return this.loadData(map.entrySet().iterator());
    }

    public <T> Future<Boolean> push(String k, T value) {
        Future<Boolean> rv = null;
        while (rv == null) {
            try {
                rv = this.client.set(k, this.expiration, value);
            }
            catch (IllegalStateException ex) {
                try {
                    if (rv != null) {
                        rv.get(250L, TimeUnit.MILLISECONDS);
                        continue;
                    }
                    Thread.sleep(250L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e2) {}
            }
        }
        return rv;
    }

    private void watch(final String key, final Future<Boolean> f) {
        if (this.executorService != null && this.storageListener != null) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        CacheLoader.this.storageListener.storeResult(key, (Boolean)f.get());
                    }
                    catch (Exception e) {
                        CacheLoader.this.storageListener.errorStoring(key, e);
                    }
                }
            });
        }
    }

    public static interface StorageListener {
        public void storeResult(String var1, boolean var2);

        public void errorStoring(String var1, Exception var2);
    }
}

